from matplotlib import pyplot as plt
import seaborn as sns
from experiments.fns import get_project_data
from experiments.fns import rename_row
from experiments.fns import label_row

target_var = "train_loss_avg"
# target_var = "test_error"
x_var = "cola_flops"
# x_var = "cola_params"
exprs = ["none", "0.0-0.5-0.5-0.0-0.5-0.0-0.5", "0.5-0.5-0.0-0.0-0.5-0.5-0.0"]
exprs = [exp + " (BMM0) Adam" for exp in exprs]

df = get_project_data(project="cifar_baselines", steps=[99, 199, 299, 399, -1])
df = df[df["state"] == "finished"]
df = df[df["epoch"] == 499]
df["vec"] = df.apply(rename_row, axis=1)
df = df[df["vec"].isin(exprs)]
df = df.loc[df.groupby(["vec", "width"])[target_var].idxmin()]
df["label"] = df.apply(label_row, axis=1)

dfb = get_project_data(project="lr_baselines")
dfb = dfb[dfb["state"] == "finished"]
dfb = dfb[dfb["epoch"] == 499]
dfb["vec"] = dfb.apply(rename_row, axis=1)
dfb = dfb[dfb["vec"].isin(exprs)]
dfb = dfb.loc[dfb.groupby(["vec", "width"])[target_var].idxmin()]
dfb["label"] = dfb.apply(label_row, axis=1)

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
plt.figure(dpi=75, figsize=(25, 15))
sns.set_palette("Set2")
sns.scatterplot(x=x_var, y=target_var, data=df, style="label", s=200)
sns.lineplot(x=x_var, y=target_var, data=df, style="label")
sns.scatterplot(x=x_var, y=target_var, data=dfb, style="label", s=200)
sns.lineplot(x=x_var, y=target_var, data=dfb, style="label")
plt.ylim([1.7, 2.2] if target_var.find("test") < -1 else None)
plt.ylabel("Train Loss" if x_var.find("train") > 0 else "Test Error")
plt.xlabel('FLOPs' if x_var == "cola_flops" else "Params")
plt.xscale('log')
plt.yscale('log')
plt.legend(loc='upper left', bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()
