### do "conda activate gpt" before running this script
export WANDB_MODE=online
export WANDB_API_KEY=1159dda0d0566b72d5cd71464a06ff6b73efb455
export WANDB__SERVICE_WAIT=300

DATA_DIR=./open_small
OUT_DIR=./
WANDB_PROJ=moe_gpt

BATCH_SIZE=64
GRAD_ACCUM=8
MAX_ITERS=100_000
BLOCK_SIZE=128

# Token batch size: 512 * 128 = 65_536
# Short seq regime: d >> N / 6 ~= 20

lr=3e-3
for num_ffn_experts in 4; do
for d_model in 256; do
# gpu_id=$(get_free_gpu "${ALLOWED_GPUs}")
# CUDA_VISIBLE_DEVICES="${gpu_id}" python
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 torchrun --nproc_per_node=8 --master_port=$(shuf -i 49152-65535 -n 1) \
train_gpt.py config/train_open_small.py --block_size=${BLOCK_SIZE} --struct=dense --layers=all_but_last --num_ffn_experts=${num_ffn_experts} --d_model=${d_model} --n_layer=3 --n_head=-1 --d_head=64 --max_iters=${MAX_ITERS} --data_dir=${DATA_DIR} --out_dir=${OUT_DIR} --batch_size=${BATCH_SIZE} --gradient_accumulation_steps=${GRAD_ACCUM} --init_lr=${lr} --wandb_project=${WANDB_PROJ} &
sleep 20
done;
done;
