from matplotlib import pyplot as plt
import seaborn as sns
from experiments.fns import get_project_data
from experiments.fns import get_baselines

x_var = "cola_flops"
df = get_project_data(project="gbtt", steps=[-1])
# target_var = "test_error"
target_var = "train_loss_avg"
print(df["expr"].unique())

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
sns.set_palette("Set2")
plt.figure(dpi=100, figsize=(20, 10))
sns.lineplot(x="lr", y="train_loss", data=df, style="expr", hue="width")
sns.scatterplot(x="lr", y="train_loss", data=df, style="expr", hue="width", s=200)
plt.ylabel("Train Loss")
plt.xlabel("lr")
plt.xscale("log")
plt.ylim([1.70, 2.5])
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

df = df.loc[df.groupby(["expr", "width"])[target_var].idxmin()]

dfb = get_baselines(project="cifar_baselines", target_var=target_var)
exprs = ["none"]
exprs += ["0.0-0.5-0.5-0.0-0.5-0.0-0.5"]
exprs += ["0.5-0.5-0.0-0.0-0.5-0.5-0.0"]
exprs = [exp + " (BMM0) Adam" for exp in exprs]
dfb = dfb[dfb["vec"].isin(exprs)]

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
plt.figure(dpi=75, figsize=(25, 15))
sns.set_palette("Set2")
sns.scatterplot(x=x_var, y=target_var, data=dfb, style="label", s=200)
sns.lineplot(x=x_var, y=target_var, data=dfb, style="label")
sns.scatterplot(x=x_var, y=target_var, data=df, style="expr", s=200)
sns.lineplot(x=x_var, y=target_var, data=df, style="expr")
plt.ylim([1.7, 2.2] if target_var.find("test") < -1 else None)
plt.ylabel("Train Loss" if target_var.startswith("train_loss") else "Test Error")
plt.xlabel("FLOPs" if x_var == "cola_flops" else "Params")
plt.xscale("log")
plt.yscale('log')
plt.legend(loc='upper left', bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()
