import matplotlib.pyplot as plt
import seaborn as sns

low = [20, 21, 23]
med = [30, 31, 33]
high = [40, 42, 45]
x = [i + 1 for i in range(len(low))]
cases = [(1, 20.5), (1, 29.5), (1, 39), (2, 22), (2, 29), (2, 41), (3, 22), (3, 33), (3, 46)]

sns.set(style="whitegrid", font_scale=2.0, rc={"lines.linewidth": 3.0})
pal = ['#e41a1c', '#377eb8', '#4daf4a', '#984ea3', '#ff7f00', '#ffff33', '#a65628']
sns.set_palette(sns.color_palette(pal))
plt.figure(dpi=100, figsize=(8, 6))
plt.title('Initialization')
plt.scatter(x, low, label='low', marker="+", c="grey")
plt.scatter(x, med, label='med', marker="v", c="grey")
plt.scatter(x, high, label='high', marker="d", c="grey")
count = 0
for loc, val in cases:
    count += 1
    label = "theory" if count == 1 else ""
    plt.scatter(loc, val, label=label, marker="o", c="#de2d26")
plt.xlabel('Structures')
plt.ylabel('Spectral Norm')
plt.xticks(ticks=x, labels=["Kron", "BTT", "Dense"])
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.savefig("init.pdf")
plt.show()
