import numpy as np


def reshape_and_multiply(A, v, d):
    new_shape = tuple([2] * d)
    A_reshaped = A.reshape((A.shape[0], ) + new_shape)
    v_reshaped = v.reshape(new_shape)
    result = np.tensordot(A_reshaped, v_reshaped, axes=d)
    return result


d = 3
N = 2**d

A = np.random.rand(N, N)
v = np.random.rand(N)
print(A @ v)
print(np.sum(A @ v))

result = reshape_and_multiply(A, v, d)
print("*=" * 50 + "\n" + "*=" * 50)
print(result)
print(np.sum(result))
