## Quick Start
### 1. Install [Singularity](https://sylabs.io/guides/3.5/user-guide/introduction.html) (optional)
If you don't want to install Singularity, make sure that you have all dependecies from Singularity.def (python3, numpy, pytorch, etc.)

a. Pull an image 
````
singularity pull library://k3nfalt/default/python_ml:sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745
````
b. Open a shell console of the image
````
singularity shell --nv ~/python_ml_sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745.sif
````
### 2. Prepare scripts for experiments


````
source prepare.sh && python3.7 code/distributed_optimization_library/experiments/asynchronous_communication/config_async.py --dataset_path NA --dumps_path SOME_PATH --experiments_name EXPERIMENTS_NAME --num_nodes 100 --step_size_range -10 10 --number_of_iterations 10000 --algorithm_names shadowheart_sgd minibatch_sgd fastest_sgd qsgd asynchronous_sgd --delays sqrt --quality_check_rate 100 --shadowheart_batch_size_list 1 5 10 20 30 40 80 100 120 150 --not_only_intel --fixed_seed 4343 --task libsvm --batch_size 4 --number_of_coordinates 700 --mkl_fix --scale_quality_check_rate 10 --gb_per_task 60
````

````
source prepare.sh && python3.7 code/distributed_optimization_library/experiments/asynchronous_communication/config_async.py --dataset_path NA --dumps_path SOME_PATH --experiments_name EXPERIMENTS_NAME --num_nodes 100 --step_size_range -10 10 --number_of_iterations 10000 --algorithm_names shadowheart_sgd minibatch_sgd fastest_sgd qsgd asynchronous_sgd --delays sqrt_grad_sqrt_send_div_sqrt_dim --quality_check_rate 100 --shadowheart_batch_size_list 1 5 10 20 30 40 80 --not_only_intel --fixed_seed 4343 --task libsvm --batch_size 4 --number_of_coordinates 700 --mkl_fix --scale_quality_check_rate 10 --gb_per_task 60
````

````
source prepare.sh && python3.7 code/distributed_optimization_library/experiments/asynchronous_communication/config_async.py --dataset_path NA --dumps_path SOME_PATH --experiments_name EXPERIMENTS_NAME --num_nodes 100 --step_size_range -10 10 --number_of_iterations 10000 --algorithm_names shadowheart_sgd minibatch_sgd fastest_sgd qsgd asynchronous_sgd --delays sqrt_grad_sqrt_send_div_div_3_over_4_dim --quality_check_rate 100 --shadowheart_batch_size_list 1 5 10 20 30 40 80 --not_only_intel --fixed_seed 4343 --task libsvm --batch_size 4 --number_of_coordinates 700 --mkl_fix --scale_quality_check_rate 10 --gb_per_task 60
````

### 3. Execute scripts
````
sh SOME_PATH/EXPERIMENTS_NAME/singularity_*.sh
````

