#!/bin/bash

# running command:
# CUDA_VISIBLE_DEVICES=0 bash scripts/Adv/advmaple/base2new.sh ce 1 1 2 100 1.0 imagenet 16 vit_b32_ep5_batch4_2ctx_notransform advMaPLe 1
# 1. attack_related
ADV_TERM=$1
EPS=$2
ALPHA=$3
TRAIN_ITER=$4
TEST_ITER=$5
LAMBDA_1=$5


ATTACK_RELATED=adv_term-${ADV_TERM}/eps-${EPS}_alpha-${ALPHA}_train_iter-${TRAIN_ITER}_test_iter-${TEST_ITER}_lambda1-${LAMBDA_1}
#2. dataset_related
DATASET=$6
SHOTS=$7

DATASET_RELATED=${DATASET}_shots_${SHOTS}

# 3. model_related 
CFG=$8
TRAINER=$9

MODEL_RELATED=${TRAINER}_${CFG}

#4. seed
SEED=${10}

SEED_RELATED=seed${SEED}

# 4. path_related
#modify this
OUTPUT_DIR=/output_dir

TRAIN_DIR=${OUTPUT_DIR}/base2new/train_base/${ATTACK_RELATED}/${DATASET_RELATED}/${MODEL_RELATED}/${SEED_RELATED}
TEST_DIR=${OUTPUT_DIR}/base2new/test_new/${ATTACK_RELATED}/${DATASET_RELATED}/${MODEL_RELATED}/${SEED_RELATED}
DATA=/data
# echo ${CLASSIFIER}

        if [ -d "$TRAIN_DIR" ]; then
            echo "Oops! The training results exist at ${TRAIN_DIR} (so skip this job)"
        else
            python train.py \
            --root ${DATA} \
            --seed ${SEED} \
            --trainer ${TRAINER} \
            --dataset-config-file configs/datasets/${DATASET}.yaml \
            --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
            --output-dir ${TRAIN_DIR} \
            DATASET.NUM_SHOTS ${SHOTS} \
            DATASET.SUBSAMPLE_CLASSES base \
            ATTACK.PGD.ADV_TERM ${ADV_TERM}\
            ATTACK.PGD.TRAIN_ITER ${TRAIN_ITER}\
            ATTACK.PGD.TEST_ITER ${TEST_ITER}\
            ATTACK.PGD.EPS ${EPS}\
            ATTACK.PGD.LAMBDA_1 ${LAMBDA_1}\
            ATTACK.PGD.ALPHA ${ALPHA}\

        fi

        # Testing section
        LOADEP=10
        SUB=new

        if [ -d "$TEST_DIR" ]; then
            echo "Oops! The testing results exist at ${TEST_DIR} (so skip this job)"
        else
            python train.py \
            --root ${DATA} \
            --seed ${SEED} \
            --trainer ${TRAINER} \
            --dataset-config-file configs/datasets/${DATASET}.yaml \
            --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
            --output-dir ${TEST_DIR} \
            --model-dir ${TRAIN_DIR} \
            --load-epoch ${LOADEP} \
            --eval-only \
            DATASET.NUM_SHOTS ${SHOTS} \
            DATASET.SUBSAMPLE_CLASSES ${SUB}\
            ATTACK.PGD.ADV_TERM ${ADV_TERM}\
            ATTACK.PGD.TRAIN_ITER ${TRAIN_ITER}\
            ATTACK.PGD.TEST_ITER ${TEST_ITER}\
            ATTACK.PGD.EPS ${EPS}\
            ATTACK.PGD.LAMBDA_1 ${LAMBDA_1}\
            ATTACK.PGD.ALPHA ${ALPHA}\

        fi
