## File Descriptions

1. **Split_responses_by_elicitation_format.py**
   - **Purpose:** Splits the dataset (responses.csv) into nine elicitation formats and three domains.
   - **Usage:** Run this script to create the "Elicitation Formats" folder, which will contain the organized datasets.
   - **Computation Resource:** A basic python3 environment and CPU.

2. **Simulations.py**
   - **Purpose:** Simulates voter behavior in the Surprisingly Popular Voting Framework.
   - **Customization:**
     - **num_voters:** Number of voters.
     - **k:** Subset size that voters will vote on.
     - **step:** Inter-alternative distance between the alternatives in the ground-truth.
   - **Usage:** Modify the parameters to simulate different voter behaviors and observe the outcomes. The default is set to k=5 and step=6.
   - **Computation Resource:** A basic python3 environment and CPU.

3. **Parameter_Inference.ipynb**
   - **Purpose:** Contains STAN code for Bayesian Inference of the parameters for both MTurk Data and Simulated Data.
   - **Customization:** Users can change the MTurk dataset to fit their needs.
   - **Usage:** Run this Jupyter Notebook to perform Bayesian Inference on the MTurk dataset of your choice and Simulated Data and the comparison between them.
   - **Computation Resource:** A basic python3 environment, pystan library (https://pystan2.readthedocs.io/en/latest/windows.html), and CPU.

4. **Aggregated-SP**
   - **Purpose:** Implements the Aggregated-SP algorithm for Borda, Copeland, and Maximin voting rules.
   - **Usage:** Running the code provides instructions for:
     - Running all possible domains, elicitation formats, and voting rules.
     - Running specific combinations of domains, elicitation formats, and voting rules.
     - Make sure to uncomment the plots section to see more metrics. We show Kendall-Tau and Spearman's Rho by default.
   - **Computation Resource:** A basic python3 environment and CPU.

5. **Partial-SP**
   - **Purpose:** Implements the Partial-SP algorithm for Borda, Copeland, and Maximin voting rules.
   - **Usage:** Running the code provides instructions for:
     - Running all possible domains, elicitation formats, and voting rules.
     - Running specific combinations of domains, elicitation formats, and voting rules.
     - Make sure to uncomment the plots section to see more metrics. We show Kendall-Tau and Spearman's Rho by default.
   - **Computation Resource:** A basic python3 environment and CPU.

6. **Responses_difficulty_time.ipynb**
   - **Purpose:** Implements the code for analysing the time spent, difficulty and expressiveness of different elicitation formats.
   - **Usage:** Run this Jupyter Notebook to see the plots for the time spent, perceived difficulty and perceived expressiveness of different elicitation formats.
   - **Computation Resource:** A basic python3 environment and CPU.   