import sys
sys.path.append("..")
import re
import os
import yaml
import json
from backend.gpt import query_gpt4

# load global config
file_path = os.path.dirname(__file__)
project_path = os.path.dirname(file_path)
global_config = yaml.safe_load(open(os.path.join(project_path, "config/global.yaml"), "r"))

all_activity = '"breakfast","lunch","dinner","sleep","exercise","work","housekeeping","meditation","yoga","grocery shopping","reading","watching tv","listening to music","playing video games","doing board games","walking the dog","gardening","laundry","online shopping","team meeting","group exercise","family dinner","conference call","movie night","group study","business presentation","camping trip","cooking class","book club meeting"'
def extract_time_intervals(text):
    pattern = r'(\d{1,2}:\d{2})-(\d{1,2}:\d{2})'
    intervals = re.findall(pattern, text)
    return [(convert_to_minutes(start), convert_to_minutes(end)) for start, end in intervals]

def convert_to_minutes(time):
    hours, minutes = map(int, time.split(":"))
    return hours * 60 + minutes

def normalize(text):
    prompt = """
given a sentence, you should extract all activities in this sentence.
you should also normalize all activity name to a standard set, which is {}
if there is no activity in the sentence, return None.
for example, if the sentence is "Cooking class attended by A0 and E0 from 20:00 to 22:00 (2 hours)",
you should return "cooking class".
if the sentence is "D1's meditation session from 13:00 to 15:00",
you should return "meditation".
if the sentence is "D9's cooking food class, E9's walking the dog, B9's watching TV series, B9's attending a master cooking cake class",
you should return "cooking class,dog walking,watching tv".
Now the sentence is {},
return the answer
"""
    prompt = prompt.format(all_activity, text)
    ans = query_gpt4(prompt)
    if ans == "None":
        return set()
    ans = ans.lower()
    ans = ans.split(",")
    ans = [item for item in ans if len(item) > 0]
    return set(ans)


file_prefix = "ScheduleMedium_GPT3.5_SingleMindPinSC_"

ans = []
fw = open(file_prefix + "result", "w")
for filename in os.listdir("./Schedule"):
    if file_prefix in filename and filename.endswith(".json"):
        print(filename)
        data = json.loads(open(os.path.join("Schedule",filename), "r").read())
        ground_truth = eval(data['answer'].lower())
        predict = data['predicted_answer']
        if not predict:
            f1 = 0
        else:
            predict = normalize(predict)
            if len(predict) == 0:
                f1 = 0
            else:
                precision = len(predict & ground_truth) / len(predict)
                recall = len(predict & ground_truth) / len(ground_truth)
                if precision == 0 and recall == 0:
                    f1 = 0
                else:
                    f1 = 2 * precision * recall / (precision + recall)
        ans.append(f1)
        fw.write("\t".join([str(data['sample_id']), str(ground_truth), str(predict), str(f1)]) + "\n")

fw.write(str(sum(ans) / len(ans)))
