import sys
sys.path.append("..")
import re
import os
import yaml
import json

# load global config
file_path = os.path.dirname(__file__)
project_path = os.path.dirname(file_path)
global_config = yaml.safe_load(open(os.path.join(project_path, "config/global.yaml"), "r"))


def extract_time_intervals(text):
    pattern = r'(\d{1,2}:\d{2})-(\d{1,2}:\d{2})'
    intervals = re.findall(pattern, text)
    return [(convert_to_minutes(start), convert_to_minutes(end)) for start, end in intervals]

def convert_to_minutes(time):
    hours, minutes = map(int, time.split(":"))
    return hours * 60 + minutes

def calculate_overlap(pred_intervals, truth_intervals):
    overlap = 0
    union = sum([a[1] - a[0] for a in pred_intervals])
    union += sum([a[1] - a[0] for a in truth_intervals])
    for pred_start, pred_end in pred_intervals:
        for truth_start, truth_end in truth_intervals:
            latest_start = max(pred_start, truth_start)
            earliest_end = min(pred_end, truth_end)
            overlap += max(0, earliest_end - latest_start)
    iou = overlap / union
    return iou


file_prefix = "ScheduleHard_GPT3.5_SingleMindPinSC_"

ans = []
fw = open(file_prefix + "result", "w")
for filename in os.listdir("./Schedule"):
    if file_prefix in filename and filename.endswith(".json"):
        print(filename)
        data = json.loads(open(os.path.join("Schedule",filename), "r").read())
        ground_truth = [item.split("-") for item in data['answer']]
        predict = data['predicted_answer']

        if not predict:
            predict = "None"
            iou = 0
        else:
            prediction_intervals = extract_time_intervals(predict)
            ground_truth_intervals = [(convert_to_minutes(start), convert_to_minutes(end)) for start, end in ground_truth]
            iou = calculate_overlap(prediction_intervals, ground_truth_intervals)
        ans.append(iou)
        fw.write("\t".join([str(data['sample_id']), str(ground_truth), predict, str(iou)]) + "\n")

fw.write(str(sum(ans) / len(ans)))
