import sys
sys.path.append("..")
import re
import os
import yaml
import json
from backend.gpt import query_gpt4
import math

# load global config
file_path = os.path.dirname(__file__)
project_path = os.path.dirname(file_path)
global_config = yaml.safe_load(open(os.path.join(project_path, "config/global.yaml"), "r"))

all_activity = '"breakfast","lunch","dinner","sleep","exercise","work","housekeeping","meditation","yoga","grocery shopping","reading","watching tv","listening to music","playing video games","doing board games","walking the dog","gardening","laundry","online shopping","team meeting","group exercise","family dinner","conference call","movie night","group study","business presentation","camping trip","cooking class","book club meeting"'
def extract_time_intervals(text):
    pattern = r'(\d{1,2}:\d{2})-(\d{1,2}:\d{2})'
    intervals = re.findall(pattern, text)
    return [(convert_to_minutes(start), convert_to_minutes(end)) for start, end in intervals]

def convert_to_minutes(time):
    hours, minutes = map(int, time.split(":"))
    return hours * 60 + minutes

def normalize(text):
    try:
        return int(text)
    except ValueError:
        prompt = """
    given a sentence, this sentence describe how many activities should be deleted.
    you should extract the number of activities that need to be deleted.
    if the sentence does not explicitly describe the number, return 0.
    if the sentence express uncertain or the answer is unknown or the answer can not be determined, return -1
    Now the sentence is {},
    return only the number
    """
        prompt = prompt.format(text)
        ans = query_gpt4(prompt)
        try:
            return int(ans)
        except:
            return -1

file_prefix = "ScheduleEasy_GPT3.5_DoubleMindPinSC_"

ans = []
fw = open(file_prefix + "result", "w")
for filename in os.listdir("./Schedule"):
    if file_prefix in filename and filename.endswith(".json"):
        print(filename)
        data = json.loads(open(os.path.join("Schedule",filename), "r").read())
        ground_truth = int(data['answer'])
        predict = data['predicted_answer']
        if not predict:
            correct = 0
        else:
            predict = normalize(predict)
            correct = predict == ground_truth
        ans.append(correct)
        fw.write("\t".join([str(data['sample_id']), str(ground_truth), str(predict), str(correct)]) + "\n")

fw.write(str(sum(ans) / len(ans)))
