import random
import requests
from datasets import load_dataset
import json

#dataset = load_dataset("google/Synthetic-Persona-Chat")
scale = 10

# 1代表半个小时
single_activities = {
    "Breakfast": {"duration": 1, "is_available": 1},
    "Lunch": {"duration": 1, "is_available": 1},
    "Dinner": {"duration": 1, "is_available": 1},
    "Sleep": {"duration": 16, "is_available": 0},
    "Exercise": {"duration": 1, "is_available": 1},
    "Work": {"duration": 2, "is_available": 0},
    "Housekeeping": {"duration": 3, "is_available": 1},
    "Meditation": {"duration": 4, "is_available": 1},
    "Yoga": {"duration": 1, "is_available": 1},
    "Grocery Shopping": {"duration": 2, "is_available": 1},
    "Reading": {"duration": 3, "is_available": 1},
    "Watching TV": {"duration": 4, "is_available": 1},
    "Listening to music": {"duration": 1, "is_available": 1},
    "Playing video games": {"duration": 2, "is_available": 1},
    "Doing board games": {"duration": 3, "is_available": 1},
    "Walking the dog": {"duration": 4, "is_available": 1},
    "Gardening": {"duration": 1, "is_available": 1},
    "Laundry": {"duration": 2, "is_available": 1},
    "Online Shopping": {"duration": 3, "is_available": 1}
}

shared_activities = {
  "Team Meeting": {"duration": 1, "is_available": 0, "participants": 2, "start_set": [20, 40]},
  "Group Exercise": {"duration": 2, "is_available": 0, "participants": 2, "start_set": [14, 40]},
  #"Family Dinner": {"duration": 2, "is_available": 0, "participants": 3, "start_set": [36, 40]},
  "Conference Call": {"duration": 3, "is_available": 0, "participants": 2, "start_set": [16, 36]},
  "Movie Night": {"duration": 4, "is_available": 0, "participants": 2, "start_set": [36, 44]},
  "Group Study": {"duration": 1, "is_available": 0, "participants": 2, "start_set": [16, 40]},
  "Business Presentation": {"duration": 2, "is_available": 0, "participants": 2, "start_set": [16, 36]},
  "Camping Trip": {"duration": 3, "is_available": 0, "participants": 2, "start_set": [14, 34]},
  "Cooking Class": {"duration": 4, "is_available": 0, "participants": 2, "start_set": [20, 40]},
  "Book Club Meeting": {"duration": 1, "is_available": 0, "participants": 2, "start_set": [20, 40]}
}

def write_jsonl(data_list, filename):
    with open(filename, 'w') as f:
        for entry in data_list:
            json.dump(entry, f)
            f.write('\n')

def read_jsonl(filename):
    data_list = []
    with open(filename, 'r') as f:
        for line in f:
            data_list.append(json.loads(line.strip()))
    return data_list


def generate_names(total_people, idx):
    names = []
    for char in "abcdefghijklmnopqrstuvwxyz".upper()[:total_people]:
        names.append(char + str(idx))
    return names

#persona_pool = dataset['train']['user 2 personas'][0:scale*10] #user2 is better
persona_pool = ['current None'] * (scale*10)
# print(persona_pool)
routine_set = {
    "Breakfast" : [12,13,14,15,16,17,18],
    "Lunch" : [22,23,24,25,26],
    "Dinner" : [34,35,36,37,38],
    "Sleep" : [44,45,46]
} # routine start time random select pool

def judge(persona, activity_name):
    print(f'{activity_name} is being judged...')
    API_URL = "URL_TO_GPT4_API_CALL"
    input_text = f"This is a persona '{persona}', please judge whether this persona is willing to {activity_name}, reply me 'yes 'or 'no'"
    data = {"text": input_text}
    response = requests.post(API_URL, json=data)
    if response.status_code == 200:
        generated_text = response.json()["response"]
    if generated_text == 'no':
        return 0
    else:
        return  1


class Person:
    def __init__(self, name, persona):
        self.name = name
        self.persona = persona
        self.time_vector = [0] * 48  # Initialized to a 48-bit all zero vector
        self.activity_willing_dict = {}
        self.activity_count = {}
        self.schedule = {} # name=key,start (list's index), end (list's index), type, participants_list


    def schedule_print(self):
        # Sort the activities by start time
        print('------------------------')
        print(f"{self.name}'s schedule:")
        # print(self.schedule)
        # print(self.time_vector)
        sorted_schedule = dict(sorted(self.schedule.items(), key=lambda item: item[1]['start']))
        for activity, details in sorted_schedule.items():
            start_hour = details['start'] // 2
            start_minute = '00' if details['start'] % 2 == 0 else '30'
            end_hour = details['end'] // 2
            end_minute = '00' if details['end'] % 2 == 0 else '30'
            participants = ' and '.join([p for p in details['participants_list'] if p != self.name])
            if details['type'] == 0:  # single person activity
                print(f"{start_hour}:{start_minute}-{end_hour}:{end_minute} {activity}")
            else:  # multi-person activity
                print(f"{start_hour}:{start_minute}-{end_hour}:{end_minute} {activity} with {participants}")


    def clear_current_schedule(self):
        self.time_vector = [0] * 48
        self.schedule_list = ['Not assigned'] * 48
        self.schedule = {}

    def generate_random_activity_vector(self, single_activities, shared_activities):
        self.activity_willing_dict = {}
        all_activities = list(single_activities.keys()) + list(shared_activities.keys())
        for activity in all_activities:
            self.activity_willing_dict[activity] = random.choice([0,1])
        self.activity_willing_dict['Sleep'] = 1 # 修正，人不能不睡觉
        self.activity_willing_dict['Lunch'] = 1  # 修正，人不能不吃午饭


    def add_schedule(self, start, end, activity_name, type, participants_list=[]):
        # print(f'add {activity_name}, start={start}, end={end}')
        if activity_name in self.activity_count.keys() and participants_list == self.schedule[activity_name+f'{self.activity_count[activity_name]}']['participants_list'] and start == self.schedule[activity_name+f'{self.activity_count[activity_name]}']['end']:
            self.schedule[activity_name+f'{self.activity_count[activity_name]}']['end'] = end
            return
        elif activity_name in self.activity_count.keys() and start != self.schedule[activity_name+f'{self.activity_count[activity_name]}']['end']:
            self.activity_count[activity_name] += 1
        elif activity_name not in self.activity_count.keys():
            self.activity_count[activity_name] = 1
        #print(start, end, activity_name, type, participants_list)
        self.schedule[activity_name+f'{self.activity_count[activity_name]}'] = {
            'start' : None,
            'end' : None,
            'type' : None,
            'participants_list' : None
        }
        self.schedule[activity_name+f'{self.activity_count[activity_name]}']['start'] = start
        self.schedule[activity_name+f'{self.activity_count[activity_name]}']['end'] = end
        self.schedule[activity_name+f'{self.activity_count[activity_name]}']['type'] = type
        self.schedule[activity_name+f'{self.activity_count[activity_name]}']['participants_list'] = participants_list


    def generate_activity_vector(self, single_activities, shared_activities):
        self.activity_willing_dict = {}
        all_activities = list(single_activities.keys()) + list(shared_activities.keys())
        print(f'{self.name} is calling judge function...')
        for activity in all_activities:
            self.activity_willing_dict[activity] = judge(self.persona, activity)
        self.activity_willing_dict['Sleep'] = 1 # 修正，人不能不睡觉
        self.activity_willing_dict['Lunch'] = 1  # 修正，人不能不吃午饭


    def generate_routine(self):
        for routine in ['Sleep', 'Lunch']:
            start = random.choice(routine_set[routine])
            round = 5
            while self.time_vector[start] != 0 and round > 0:
                start = random.choice(routine_set[routine])
                round -= 1
            if self.time_vector[start] != 0:
                continue
            end = start + single_activities[routine]['duration']
            if self.time_vector[end%48-1] != 0:
                continue
            if end > 48:
                end_after = end % 48
                self.time_vector[0:end_after] = [1] * end_after
                self.time_vector[start:48] = [1] * (48 - start)

                self.add_schedule(0, end_after, routine, 0, [self.name])
                self.add_schedule(start, 48, routine, 0, [self.name])
                # print(f'{self.name}2-sleep:{self.time_vector}')
            else:
                self.time_vector[start:end] = [1] * (end - start)
                self.add_schedule(start, end, routine, 0, [self.name])
                # print(f'{self.name}2-{routine}:{self.time_vector}')


    def generate_schedule(self):
        round = 5

        # 对于avaiable活动，直接将其以一定概率删除，留出空时间段来提问
        skip_available_prob = 0.1
        while round > 0:
            start = 0
            end = 1
            while end < 48 and start < end:
                #print(start)
                #print(len(self.time_vector))
                while start < 48 and self.time_vector[start] != 0:
                    start += 1
                if start >= 48:
                    break
                end = start + 1
                while end < 48 and self.time_vector[end] != 1:
                    end += 1
                time_span = end - start
                flag = 0
                round_notlike = 5
                while flag == 0 and round_notlike >= 0:
                    #print(round_notlike)
                    round_notlike -= 1
                    if time_span > 4:
                        selected_activity = random.choice([key for key in single_activities.keys() if single_activities[key]['duration']>=4 and key not in ['Lunch', 'Sleep']])
                        end = start + single_activities[selected_activity]['duration']
                        self.time_vector[start:end] = [1] * (end - start)
                        if random.random() < skip_available_prob:
                            self.add_schedule(start, end, selected_activity, 0, [self.name])

                        # print(f'{self.name}3-{selected_activity}:{self.time_vector}')
                        flag = 1
                    else:
                        selected_activity = random.choice([key for key in single_activities.keys() if key not in ['Lunch', 'Sleep']])
                        if single_activities[selected_activity]['duration'] <= time_span and (self.activity_willing_dict[selected_activity] == 1 or round_notlike == 0):
                            end = start+single_activities[selected_activity]['duration']
                            #self.time_vector[start:end] = [1] * (end - start)
                            self.time_vector[start:end] = [1] * (end - start)
                            if random.random() < skip_available_prob:
                                self.add_schedule(start, end, selected_activity, 0, [self.name])
                            # print(f'{self.name}3-{selected_activity}:{self.time_vector}')
                            flag = 1
            round -= 1

def write_activity_willing_dict(agent_pool):
    activity_willing_dict = {}
    for agent in agent_pool.keys():
        agent_pool[agent].clear_current_schedule()
        #agent_pool[agent].schedule_print()
        agent_pool[agent].generate_activity_vector(single_activities, shared_activities)
        activity_willing_dict[agent] = agent_pool[agent].activity_willing_dict
        # print(agent_pool[agent].activity_willing_dict)
        # agent_pool[agent].activity_willing_dict = activity_willing_dict[agent]

    with open('activity_willing_dict.json', 'w') as f:
        json.dump(activity_willing_dict, f)

def main():
    total_people = 6
    #
    # schedule_dict = {}
    # for agent in agent_pool.keys():
    #     agent_pool[agent].generate_routine()
    #     agent_pool[agent].generate_schedule()
    #     schedule_dict[agent] = agent_pool[agent].schedule
    #     agent_pool[agent].schedule_print()
    # #
    # with open('schedule_dict_0430.json', 'w') as f:
    #     json.dump(schedule_dict, f)

    schedule_data_list = []
    activity_willing_dict = []
    for i in range(scale):

        name_pool = generate_names(total_people, i)
        # generate agent dictionary
        agent_pool = {name: Person(name, persona) for name, persona in zip(name_pool, persona_pool)}
        #print(agent_pool)
        activity_willing_dict = {}
        # generate willing dict
        for agent in agent_pool.keys():
            agent_pool[agent].clear_current_schedule()
            #agent_pool[agent].schedule_print()

            agent_pool[agent].generate_random_activity_vector(single_activities, shared_activities)
            activity_willing_dict[agent] = agent_pool[agent].activity_willing_dict
            # print(agent_pool[agent].activity_willing_dict)
            # agent_pool[agent].activity_willing_dict = activity_willing_dict[agent]

        for agent in agent_pool.keys():
            agent_pool[agent].clear_current_schedule()
            agent_pool[agent].activity_willing_dict = activity_willing_dict[agent]

        # for agent in agent_pool.keys():
        #     print(agent_pool[agent].activity_willing_dict)
        #
        # randomly select shared activities
        shared_activities_num = random.randint(1, total_people//3)
        items = list(shared_activities.items())
        random_items = random.sample(items, shared_activities_num)
        extracted_shared_activities = dict(random_items)
        # #
        # randomly select participants for each extracted shared activity and choose a random time for it
        shared_activities_info = {}
        for activity in extracted_shared_activities.keys():
            participants_num = extracted_shared_activities[activity]['participants']
            
            # random_items = random.sample(name_pool, participants_num)
            # 不能跨样本sample
            random_items = random.sample(name_pool, participants_num)

            shared_activities_info[activity] = {}
            shared_activities_info[activity]['participants_list'] = random_items
            shared_activities_info[activity]['start'] = random.choice(shared_activities[activity]['start_set'])
            shared_activities_info[activity]['end'] = shared_activities_info[activity]['start'] + shared_activities[activity]['duration']


        # add shared activities to the agent's schedule
        for activity in shared_activities_info.keys():
            for name in shared_activities_info[activity]['participants_list']:
                agent_pool[name].add_schedule(shared_activities_info[activity]['start'], shared_activities_info[activity]['end'], activity, 1, shared_activities_info[activity]['participants_list'])
                start = shared_activities_info[activity]['start']
                end = shared_activities_info[activity]['end']
                agent_pool[name].time_vector[start:end] = [1] * (end - start)
                
                # print(f'{name}1:{agent_pool[name].time_vector}')

        schedule_dict = {}
        for j in range(total_people):
            agent_pool[name_pool[j]].generate_routine()
            agent_pool[name_pool[j]].generate_schedule()
            schedule_dict[name_pool[j]] = agent_pool[name_pool[j]].schedule
            agent_pool[name_pool[j]].schedule_print()
        schedule_data_list.append(schedule_dict)

    write_jsonl(schedule_data_list, 'schedule_data_list_part2.jsonl')
    # read_data = read_jsonl('schedule_data_list.jsonl')
    # print(read_data)








main()