import requests
import json
import csv
import re
API_URL = "URL_TO_GPT4_API_CALL"

def schedule_dict_2_str(name, schedule_dict):
    schedule_str = ''
    sorted_schedule = dict(sorted(schedule_dict.items(), key=lambda item: item[1]['start']))
    for activity, details in sorted_schedule.items():
        start_hour = details['start'] // 2
        start_minute = '00' if details['start'] % 2 == 0 else '30'
        end_hour = details['end'] // 2
        end_minute = '00' if details['end'] % 2 == 0 else '30'
        participants = ' and '.join([p for p in details['participants_list'] if p != name])
        if details['type'] == 0:  # single person activity
            schedule_str += f"{start_hour}:{start_minute}-{end_hour}:{end_minute} {activity[:-1]}\n"
        else:  # multi-person activity
            schedule_str += f"{start_hour}:{start_minute}-{end_hour}:{end_minute} {activity[:-1]} with {participants}\n"
    return schedule_str



def write_one_sample(schedule_dict, writer):
    # print(f'schedule_dict: {schedule_dict}')
    agent_sorted_pool = sorted(schedule_dict.keys(), key=lambda x: (int(x[1:]), x[0]))
    # print(f'agent_sorted_pool: {agent_sorted_pool}')
    i = 0
    j = 0
    total_people = 6
    while i < len(agent_sorted_pool):
        for j in range(1,total_people // 2):
            # print(schedule_dict_2_str(agent_sorted_pool[i], schedule_dict[agent_sorted_pool[i]]))
            input_text = '''
The following is {person1}'s and {person2}'s schedule for tomorrow.
Please design the conversations between them so that they understand each other's schedules. Notice,
1. When {person1} and {person2} have activities that they participate in together, the names of the participants in the joint activities can be mentioned in the conversation;
2. If either party {person1} or {person2} does not participate in an activity, the participating party cannot mention the names of other participants in the activity;
3. Please follow this format when generating dialogue. For example: when {person1} talks to {person2}, the format is ‘{person1} to {person2}: ‘.
{person1}'s schedule:
{person1_schedule}
{person2}'s schedule:
{person2_schedule}
            '''.format(person1=agent_sorted_pool[i],
                       person2=agent_sorted_pool[i+j],
                       person1_schedule=schedule_dict_2_str(agent_sorted_pool[i], schedule_dict[agent_sorted_pool[i]]),
                       person2_schedule=schedule_dict_2_str(agent_sorted_pool[i+j], schedule_dict[agent_sorted_pool[i+j]]))
            print(f'inputtext: {input_text}')
            data = {"text": input_text}
            response = requests.post(API_URL, json=data)
            if response.status_code == 200:
                generated_text = response.json()["response"]
                print("Generated text:\n", generated_text)
                messages = generated_text.strip().split('\n')
                # 遍历每条消息
                for message in messages:
                    # 使用正则表达式分割消息为发送者、接收者和消息文本
                    match = re.match(r'(\w+) to (\w+): "(.*)"', message)
                    if match:
                        sender, receiver, message_text = match.groups()
                        writer.writerow([sender, receiver, message_text])  # 写入一行数据

        i += total_people // 2


fw = open('dialogue_part2.csv', 'a', newline='')
writer = csv.writer(fw)
writer.writerow(["sender", "receiver", "message"])  # 写入表头


with open("./schedule_data_list_part2.jsonl", 'r') as f:
    for line in f:
        schedule_dict = json.loads(line.strip())
        write_one_sample(schedule_dict, writer)