import os

import mysql.connector
import yaml

project_path = os.path.dirname(__file__)
global_config = yaml.safe_load(open(os.path.join(project_path, "config/global.yaml"), "r"))


DATABASE_USER = global_config.get("mysql").get("username")
DATABASE_PASSWD = global_config.get("mysql").get("password")
HOST = global_config.get("mysql").get("host")
DATABASE = global_config.get("mysql").get("database")

db_config = {'host': HOST, 'user': DATABASE_USER, 'password': str(DATABASE_PASSWD)}

conn = mysql.connector.connect(**db_config)
cursor = conn.cursor(buffered=True)


def create_database(cursor):
    try:
        cursor.execute("CREATE DATABASE IF NOT EXISTS {}".format(DATABASE))
        print("Database '{}' created successfully".format(DATABASE))
    except mysql.connector.Error as err:
        print("Error creating database '{}':".format(DATABASE), err)


def create_users_table(cursor):
    try:
        cursor.execute("""
            CREATE TABLE IF NOT EXISTS users (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL UNIQUE,
                password VARCHAR(255) NOT NULL
            )
        """)
        print("Table 'users' created successfully")
    except mysql.connector.Error as err:
        print("Error creating table 'users':", err)


def create_friendships_table(cursor):
    try:
        cursor.execute("""
            CREATE TABLE IF NOT EXISTS friendships (
                user_id INT,
                friend_id INT,
                PRIMARY KEY (user_id, friend_id),
                FOREIGN KEY (user_id) REFERENCES users(id),
                FOREIGN KEY (friend_id) REFERENCES users(id)
            )
        """)
        print("Table 'friendships' created successfully")
    except mysql.connector.Error as err:
        print("Error creating table 'friendships':", err)


def create_chats_table(cursor):
    try:
        cursor.execute("""
            CREATE TABLE IF NOT EXISTS chats (
                id INT AUTO_INCREMENT PRIMARY KEY,
                sender VARCHAR(255) NOT NULL,
                receiver VARCHAR(255) NOT NULL,
                message TEXT NOT NULL,
                timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )
        """)
        print("Table 'chats' created successfully")
    except mysql.connector.Error as err:
        print("Error creating table 'chats':", err)


def insert_friendship_data(cursor, user_id, friend_id):
    try:
        cursor.execute(
            """
            INSERT INTO friendships (user_id, friend_id)
            VALUES (%s, %s)
        """, (user_id, friend_id))
        print("Friendship data inserted successfully: {}, {}".format(user_id, friend_id))
    except mysql.connector.Error as err:
        print("Error inserting Friendship data:", err)

def insert_user_data(cursor, id, name, password):
    try:
        cursor.execute(
            """
            INSERT INTO users (id, name, password)
            VALUES (%s, %s, %s)
        """, (id, name, password))
        print("User data inserted successfully: {}, {}, {}".format(id, name, password))
    except mysql.connector.Error as err:
        print("Error inserting user data:", err)

def fetch_all_users(cursor):
    try:
        cursor.execute("SELECT * FROM users")
        rows = cursor.fetchall()
        for row in rows:
            print(row)
    except mysql.connector.Error as err:
        print("Error fetching user data:", err)


def main():
    create_database(cursor)

    cursor.execute("USE chat_db")

    create_users_table(cursor)

    create_friendships_table(cursor)

    create_chats_table(cursor)

    conn.commit()
    cursor.close()
    conn.close()


if __name__ == "__main__":
    main()
