import logging
import os
import yaml
from datetime import datetime
import time
import csv


# load global config
file_path = os.path.dirname(__file__)
project_path = os.path.dirname(file_path)
global_config = yaml.safe_load(open(os.path.join(project_path, "config/global.yaml"), "r"))

class AvatarLogger():
    def __init__(self) -> None:
        pass

    @classmethod
    def set_logger(self, logger):
        self.logger = logger

    @classmethod
    def set_evaluate_log_path(self, exp_name, file_prefix):
        csv_log_path = os.path.join(project_path, "exp", exp_name, global_config.get('logging').get('logname') + "_{}_llm.csv".format(file_prefix))
        if os.path.exists(csv_log_path):
            self.writer = csv.writer(open(csv_log_path, "a", newline=''))
        else:
            self.writer = csv.writer(open(csv_log_path, "w", newline=''))
            self.writer.writerow(['timestamp','instruction/none-llm operation','query','response'])

    @classmethod
    def set_log_path(self, file_timestamp):
        csv_log_path = os.path.join(project_path, "logs", global_config.get('logging').get('logname') + "_{}_llm.csv".format(file_timestamp))
        if os.path.exists(csv_log_path):
            self.writer = csv.writer(open(csv_log_path, "a", newline=''))
        else:
            self.writer = csv.writer(open(csv_log_path, "w", newline=''))
            self.writer.writerow(['timestamp','instruction','query','response'])
    
    @classmethod
    def log(cls, query=None, response=None, instruction=None):
        """write log to two files,
        logname_raw.log: plain text with all loggings
        logname_llm.csv: structued text with all loggings, including four columns:[timestamp, instruction on this llm call/or none-llm operation, query, response]

        Args:
            query (str): query to call llm
            response (str): response from llm
            instruction (str, optional): the explaination on this llm call. Defaults to None.
        """
        current_timestamp = datetime.now().timestamp()
        current_datetime = datetime.fromtimestamp(current_timestamp)
        timestamp = current_datetime.strftime("%Y-%m-%d %H:%M:%S")
        if not instruction:
            instruction = "None"
        cls.writer.writerow([timestamp, instruction, query, response])
        if query or response:
            if not query:
                query = "None"
            if not response:
                response = "None"
            instruction += "\n>>>>>>>> Input >>>>>>>>:\n{}\n<<<<<<<< Output <<<<<<<<:\n{}\n".format(query, response)
        if hasattr(cls, 'logger'):
            cls.logger.info(instruction)
        else:
            logging.info(instruction)