import logging
import os
from datetime import datetime
import yaml
from flask import Flask, render_template, request, redirect, session, jsonify, send_from_directory

from avatarchat.sql import *
from avatarchat.mode import Mode
from avatarchat.util import AvatarLogger

project_path = os.path.dirname(__file__)
global_config = yaml.safe_load(open(os.path.join(project_path, "config/global.yaml"), "r"))

app = Flask(__name__)
app.secret_key = global_config.get("website").get("flask_secret")

current_timestamp = datetime.now().timestamp()
current_datetime = datetime.fromtimestamp(current_timestamp)
timestamp = current_datetime.strftime("%Y-%m-%d-%H-%M-%S")

AvatarLogger.set_log_path(file_timestamp=timestamp)
logging.basicConfig(filename=os.path.join(project_path, "logs", global_config.get('logging').get('logname') + "_{}_raw.log".format(timestamp)),
                    level=global_config.get('logging').get('level'),
                    format='[%(asctime)s %(levelname)s]\n%(message)s',
                    datefmt='%Y-%d-%m %H:%M:%S',
                    encoding="utf-8")

@app.route('/register', methods=['GET', 'POST'])
def register():
    if request.method == 'POST':
        name = str(request.form['username'])
        password = str(request.form['password'])
        try:
            _ = exec_sql("INSERT INTO users (name, password) VALUES (%s, %s)", params=(name, password), mode="write")
            return redirect('/login')
        except mysql.connector.IntegrityError:
            return 'Username already exists. Please choose a different one.'
    return render_template('register.html')


@app.route('/login', methods=['GET', 'POST'])
def login():
    if request.method == 'POST':
        name = str(request.form['username'])
        password = str(request.form['password'])
        result = exec_sql("SELECT id FROM users WHERE name=%s AND password=%s", params=(name, password))
        user_id = result[0]
        if user_id:
            session['name'] = name
            session['user_id'] = user_id[0]
            return redirect('/chat')
        else:
            return 'Invalid username or password'
    return render_template('login.html')


@app.route('/add_friend', methods=['POST'])
def add_friend():
    if 'name' not in session:
        return redirect('/login')

    friend_name = str(request.form['friend_name'])
    result = exec_sql("SELECT id FROM users WHERE name=%s", params=(friend_name,))
    friend = result[0]
    if friend:
        _ = exec_sql("INSERT INTO friendships (user_id, friend_id) VALUES (%s, %s), (%s, %s)", params=(session['user_id'], friend[0], friend[0], session['user_id']), mode="write")
    return redirect('/chat')


@app.route('/get_messages')
def get_messages():
    if 'name' not in session:
        return jsonify({'error': 'Unauthorized'}), 401

    current_chat = request.args.get('chat')
    if current_chat:
        chat_history = exec_sql(
            """
                SELECT sender, receiver, message, timestamp 
                FROM chats 
                WHERE 
                ((sender IN (%s, %s)) AND (receiver IN (%s, %s))) OR
                ((sender IN (%s, %s)) AND (receiver IN (%s, %s)))
                ORDER BY timestamp
            """, params=(session['name'], session['name'] + "'s Agent", current_chat, current_chat + "'s Agent",
                  current_chat, current_chat + "'s Agent", session['name'], session['name'] + "'s Agent"))

        messages = [{
            'sender': sender,
            'receiver': receiver,
            'message': message,
            'timestamp': timestamp
        } for sender, receiver, message, timestamp in chat_history]
        return jsonify({'messages': messages}), 200
    else:
        return jsonify({'error': 'No chat specified'}), 400


@app.route('/send_message', methods=['POST'])
def send_message():
    if 'name' not in session:
        return jsonify({'error': 'Unauthorized'}), 401

    receiver = request.form['receiver']
    message = request.form['message']
    sender = request.form['sender']
    message = message.replace('"','')
    if receiver and message:
        _ = exec_sql("INSERT INTO chats (sender, receiver, message) VALUES (%s, %s, %s)", params=(sender, receiver, message), mode="write")

        # # TODO: deal with agent admin panel message
        # if not receiver:
        #     cursor = exec_sql("INSERT INTO chats (sender, receiver, message) VALUES (%s, %s, %s)".format("ADMIN", sender, "Agent Cultivate Feature in Developing......"))
        #     conn.commit()
        #     cursor.close()
        
        return jsonify({'success': True}), 200
    else:
        return jsonify({'error': 'Receiver and message are required'}), 400


@app.route('/logout')
def logout():
    session.pop('name', None)
    return redirect('/login')


@app.route('/')
def index():
    return redirect('/login')


@app.route('/chat')
def chat_page():
    if 'name' not in session:
        return redirect('/login')

    friend_list = exec_sql("SELECT name FROM users WHERE id IN (SELECT friend_id FROM friendships WHERE user_id=\"{}\")".format(session['user_id']))
    friend_name = request.args.get('chat')
    return render_template('chat.html', friend_list=friend_list, friend_name=friend_name)


@app.route('/static/<path:path>')
def send_static(path):
    return send_from_directory('static', path)


@app.route('/execute_agent')
def execute_agent():
    if 'name' not in session:
        return jsonify({'error': 'Unauthorized'}), 401

    receiver = request.args.get('receiver')
    task_prompt = request.args.get('message').lstrip("@")
    sender = request.args.get('sender')

    # start the agents' communication
    # see avatarchat.mode for different settings
    if receiver:
        mode = Mode(sender=sender, receiver=receiver, task=task_prompt, global_config=global_config)
        communication = mode.get_communication()
        response = communication.communicate()

        return jsonify({'agent_response': response}), 200
    else:
        return jsonify({'error': 'No chat receiver specified'}), 400


if __name__ == '__main__':
    HOST = global_config.get("website").get("host")
    PORT = global_config.get("website").get("port")
    print("AvatarChat is available at localhost:{}/login".format(PORT))
    app.run(host=HOST, debug=True, port=PORT, use_reloader=False)
