# Autonomous Agents for Collaborative Task under Information Asymmetry

-   This repository is the official implementation of [Autonomous Agents for Collaborative Task under Information Asymmetry](xxxxxx).  including
    - a lightweight demo for presenting our study, named AvatarChat (each human user can obtain their avatar in the agent world). Start the demo by ``python3 app.py``.
    - the agent framework iAgents. Seen in ``avatarchat/``.
    - the benchmark InformativeBench. Seen in ``data/``.
    - all experiment results. Seen in ``exp/``.

<p align="center">
  <img src='./figs/overall.png' width=550>
</p>

## Requirements

-   To install requirements:

```setup
pip install -r requirements.txt
```
 ##

## QuickStart

### prepare config
-   To start the demo, first modify the configuration file ``config/global.yaml`` based on your need. Usually you only need to provide
    -   your openai_api_key for invoking GPT calls
    -   your mysql password 
    -   your mysql username
    -   your mysql database name (you do not have to create it in advance) 

### prepare database
-   Run ``python3 create_database.py``, then it would create a database using the mysql configs in the ``config/global.yaml``
-   If you want to import the database used in the InformativeBench, please run the following commands
```
cd data/Friends && python3 Friends_import_db.py
cd data/Needle && python3 Needle_import_db.py
cd data/Schedule && python3 Schedule_import_db.py
```

### start the demo
run this command:

```
python3 app.py
```

-   Then go to ``localhost:6060/login``. You would see a login page and you can create user and login it just like a IM app.

<p align="center">
  <img src='./figs/login.png' width=550>
</p>

-   after login, you can see the main UI. You can add friends, start new chat and read the introduction on how to summon your agent.

<p align="center">
  <img src='./figs/main.png' width=550>
</p>

-   For example, here demo_user added alice_0 as a friends. He can chat with alice_0 just like using usual IM apps, but also could add a "@" before his message to summon agents for autonomous communication for task solving.

<p align="center">
  <img src='./figs/alice.png' width=550>
</p>

## InformativeBench

-   To evaluate iAgents on InformativeBench, run:

```
python3 run_exp_Friends.py
python3 run_exp_Needle.py
python3 run_exp_Schedule.py
```

-   It will start iAgents on InformativeBench without starting the AvatarChat demo. The generated results are in ``exp/`` 
-   After the generation, you can evaluate the results by running
```
cd exp && python3 evaluate_friends.py
cd exp && python3 evaluate_needle.py
cd exp && python3 evaluate_schedule_easy.py
cd exp && python3 evaluate_schedule_hard.py
cd exp && python3 evaluate_schedule_medium.py
```

## Results

iAgents achieve the following performance, which are calculated from ``exp/*_result``:

<p align="center">
  <img src='./figs/result.png' width=550>
</p>


## Contributing
-   This project is licenced under CC BY-NC 4.0.