# PID

This project provides scripts to generate and visualize PID (Partial Information Decomposition) values, redundancy visuals, and image editing results using the `sdm_2_1_base` model. The following sections detail the commands required to generate and visualize these data.

## Prerequisites

Ensure you have Python installed along with any necessary dependencies for running the scripts. We have included the `requirements.txt` file.

## Usage

### Generate and Store PID Values

To generate and store PID values, use the following command:

```sh
python -m scripts.eval_itd --res_out_dir <results_path> --data_in_dir <data_path> \
--sdm_version 'sdm_2_1_base' --n_samples_per_point 1 --num_steps 50 --batch_size 1 \
--logsnr_loc 1.0 --logsnr_scale 2.0 --clip 3.0 \
--upscale_mode 'bilinear' --int_mode 'logistic' \
--csv_name <csv_name> --res_type 'pid' --eval_metrics 'pid' --seed 42 --dataset_type 'custom' --word_freq_model \
```

## To generate PID visuals from the stored PID values, use the following command:

```sh 
python -m scripts.visual --fig_out_dir <figs_path> --res_in_dir <results_path> --data_in_dir <data_path> --n_samples_per_point 1 --num_steps 50 --int_mode 'logistic' --sdm_version 'sdm_2_1_base' --csv_name <csv_name> --seed 42 --visual_type 'pid' --dataset_type 'custom' --cmap 'inferno'
```


## To generate redundancy visuals (showing the redundancy versus intersection of CMI, MI, DAAM), use the following command:
```sh 
python -m scripts.visual --fig_out_dir <figs_path> --res_in_dir <results_path> --data_in_dir <data_path> --n_samples_per_point 1 --num_steps 50 --int_mode 'logistic' --sdm_version 'sdm_2_1_base' --csv_name <csv_name> --seed 42 --visual_type 'redun' --dataset_type 'custom' --cmap 'inferno'
```

## To generate prompt intervention results:

```sh
python -m scripts.image_edit --res_out_dir <results_path> --data_in_dir <data_path> \
--sdm_version 'sdm_2_1_base' --num_steps 50 --batch_size 1 --clip 3.0 \
--csv_name <csv_name> --seed 42 --dataset_type 'custom'
```

## To generate image editing visuals:
```sh
python -m scripts.visual --fig_out_dir <figs_path> --res_in_dir <results_path> --data_in_dir <data_path> --n_samples_per_point 1 --num_steps 50 --int_mode 'logistic' --sdm_version 'sdm_2_1_base' --csv_name <csv_name> --seed 42 --visual_type 'img_edit' --dataset_type 'custom' --cmap 'inferno' --eval_metrics 'img_edit'
```