Causal CPC
==============================
Causal Contrastive Learning for Counterfactual Regression Over Time.

The code extends the project of [Causal Transformer](https://arxiv.org/abs/2204.07258) avialable at https://github.com/Valentyn1997/CausalTransformer/tree/main?tab=MIT-1-ov-file
and released under MIT license.

### Installations
```console
conda create -n myenv python=3.10
conda activate myenv
pip install -r requirements.txt
```

The project uses the Hydra package to manage configuration files. All model configurations are in config/backbone, and those of the data are in config/dataset.

For MIMIC III data, please place ([all_hourly_data.h5](https://github.com/MLforHealth/MIMIC_Extract)) to `data/processed/`

The config/config.yaml provides general configuration parameters, especially Hydra defaults that specify which model backbone to use, the dataset, and hyperparameter values.

An example of use for Causal CPC is
```console
PYTHONPATH=. python3 runnables/train_ccpc_rep_est.py exp.seed=10
```
