import json
import numpy as np
import os

results_path = './results/'
excess_loss = {}
opt_algs = ["DPGD", "DN-Hess-add", "DN-UB-add", "DN-Hess-clip", "DN-UB-clip", "Newton", "obj-perturb"]
for filename in os.listdir(results_path):
    f = os.path.join(results_path, filename)
    with open(f) as json_file:
        data = json.load(json_file)
        for alg in data.keys():
            if alg in opt_algs:
                loss_avg, loss_std = np.array(data[alg]['loss_avg']), np.array(data[alg]['loss_std'])
                if alg == 'obj-perturb':
                    print('excess loss of ' + alg + ': ' + str(loss_avg)+','+'it is not an iterative algorithm.')
                else:
                    clock_time = np.array(data[alg]['clock_time_avg'])
                    print('excess loss of ' + alg + ': ' + str(loss_avg[-1]) + ', run time: ' + str(clock_time[-1]) + '(sec)')








