
#include <string.h>
#include <omp.h>

#include <scip/scip.h>
#include <scip/scipdefplugins.h>

#include "sepa_localcuts.h"

/** define macro to print error message and exit */
#define SCIP_CALL_ERROR(x)   do                                                                               \
                       {                                                                                      \
                          SCIP_RETCODE _restat_;                                                              \
                          if( (_restat_ = (x)) != SCIP_OKAY )                                                 \
                          {                                                                                   \
                             SCIPprintError(_restat_);                                                        \
                             return -1;                                                                       \
                           }                                                                                  \
                       }                                                                                      \
                       while( FALSE )


/** main function */
int main(
   int                   argc,               /**< number of arguments from the shell */
   char**                argv                /**< array of shell arguments */
   )
{
   SCIP* scip = NULL;

   /* initialize SCIP */
   SCIP_CALL_ERROR( SCIPcreate(&scip) );

   /* output version information */
   SCIPinfoMessage(scip, NULL, "Using local cuts for knapsacks.\n");
   SCIPinfoMessage(scip, NULL, "\n");

   SCIPinfoMessage(scip, NULL, "Configuration:\n");
#ifdef USE_FW_SEPA
   SCIPinfoMessage(scip, NULL, "- Frank-Wolfe\n");
#else
   SCIPinfoMessage(scip, NULL, "- LP-based separation\n");
#endif

#ifdef HYBRID_ORACLE
   SCIPinfoMessage(scip, NULL, "- hybrid oracle\n");
#else
   SCIPinfoMessage(scip, NULL, "- dynamic programming oracle\n");
#endif
   SCIPinfoMessage(scip, NULL, "\n");

   /* include default SCIP plugins */
   SCIP_CALL_ERROR( SCIPincludeDefaultPlugins(scip) );

   /* include local cut separator */
   SCIP_CALL_ERROR( SCIPincludeSepaLocalcuts(scip) );

   SCIP_CALL_ERROR( SCIPsetIntParam(scip, "display/verblevel", 5) );

   /* Process command line arguments */
   SCIP_CALL_ERROR( SCIPprocessShellArguments(scip, argc, argv, "scip.set") );

   /* free SCIP */
   SCIP_CALL_ERROR( SCIPfree(&scip) );

   BMScheckEmptyMemory();

   return 0;
}
