import numpy as np
from scipy.integrate import quad
from instances import double_well_instance
from core import LMC

sigma = 1.
inst = double_well_instance(sigma)

f = lambda x: x**2 * np.exp(-(x**2 / 2 - np.log(1 + x**2)) / (2 * sigma**2))
num2 = quad(f, -30, 30)[0]
f = lambda x: np.exp(-(x**2 / 2 - np.log(1 + x**2)) / (2 * sigma**2))
den = quad(f, -30, 30)[0]

truth = np.array([0, num2 / den, 0.5])

nrep = 20
m_list = np.arange(15, 24)
methods = ['mc', 'cud']
lr = 0.01
errors = {}

def get_errors(samples):
    results = np.zeros(3)
    results[0] = np.mean((np.mean(samples, 0) - truth[0])**2)
    results[1] = np.mean((np.mean(samples**2, 0) - truth[1])**2)
    results[2] = np.mean((np.mean(samples > 0, 0) - truth[2])**2)
    return results

for j, m in enumerate(m_list):
    print(m)
    n = 2**m
    errors[('mc', m)] = np.zeros((nrep, 3))
    errors[('cud', m)] = np.zeros((nrep, 3))
    for seed in range(nrep):    
        lmc = LMC(inst, lr, n, seed, cud=False)
        errors[('mc', m)][seed] = get_errors(lmc)

        lmc_cud = LMC(inst, lr, n, seed, cud=True)
        errors[('cud', m)][seed] = get_errors(lmc_cud)

