from scipy.stats import binom
from scipy.stats import norm

import matplotlib.pyplot as plt
import numpy as np
from statistics import NormalDist
import math
import tensorflow as tf
import time 
gpus = tf.config.experimental.list_physical_devices('GPU')
if gpus:
  try:
    tf.config.experimental.set_virtual_device_configuration(
        gpus[0],
        [tf.config.experimental.VirtualDeviceConfiguration(memory_limit=6000)])
    logical_gpus = tf.config.experimental.list_logical_devices('GPU')
    print(len(gpus), "Physical GPUs,", len(logical_gpus), "Logical GPUs")
  except RuntimeError as e:
    # Memory growth must be set before GPUs have been initialized
    print(e)

def sparsification_with_prob(value,A,B,d):
    random_vec = np.random.rand(d)
    compare_vec = np.less(random_vec,np.divide(np.add(value,A),2*A))
    quantized_vec = np.multiply(np.subtract(compare_vec.astype(int),0.5*np.ones(d)),2)
    
    random_vec = np.random.rand(d)
    compare_vec = np.less(random_vec,np.ones(d)*A/B)
    sparsified_vec = np.multiply(quantized_vec,compare_vec.astype(int))

    return sparsified_vec


def prob_correct_aggregation(true_value,aggregated_value,d):
    num_correct_signs = 0
    for i in range(d):
        if aggregated_value[i] == 0:
            num_correct_signs += 0.5
        else:
            if np.sign(true_value[i]) == np.sign(aggregated_value[i]):
                num_correct_signs += 1
    return num_correct_signs/d


def gaussian_sparsification_with_prob(value,sigma,A,B,d):
    random_vec = np.random.rand(d)
    compare_vec = np.less(random_vec,np.ones(d)*A/B)
    sparsified_vec = np.multiply(np.multiply(np.add(value,np.random.normal(0,sigma,d)),compare_vec.astype(int)),B/A)
    
    return sparsified_vec

def gaussian_addnoise(value,sigma,d):
    
    sparsified_vec = np.add(value,np.random.normal(0,sigma,d))
    
    return sparsified_vec


def SQKR(value,epsilon,k,d,c_inf):
    random_vec = np.random.rand(d)
    compare_vec = np.less(random_vec,np.divide(np.add(value,c_inf),2*c_inf))
    quantized_vec = np.multiply(np.subtract(compare_vec.astype(int),0.5*np.ones(d)),2)
    sampled_indices = np.random.choice(d, k,replace = True)
    sampled_vec = quantized_vec[sampled_indices]
    
    if np.random.rand() < np.exp(epsilon)/(np.exp(epsilon)+2**k-1):
        private_vec = sampled_vec.copy()
    else:
        indicator_same = True
        while indicator_same:
            rand_vec = 2*(np.random.randint(2, size=k)-0.5)
            if np.sum(rand_vec) < k:
                indicator_same = False
                private_vec = np.multiply(sampled_vec,rand_vec)
    
    SQKR_value = np.zeros(d)
    for i in range(k):
        index = sampled_indices[i]
        SQKR_value[index] = np.add(SQKR_value[index],(d*(np.exp(epsilon)+2**k-1)/(k*(np.exp(epsilon)-1)))*private_vec[i]*c_inf)
    
    return SQKR_value
        
    
    
    
    
    



time1 = time.time()
MC = 10000
N = 1000
d = 250
c_inf = 1/np.sqrt(d)
c_2 = 1
# sigma_set = [1/5,1/4,1/3,1/2,1,2,3,4,5]
mean = 1e-4
[user_value,true_value] = np.load('record_mean0_0001_uservalue.npy',allow_pickle=True)
epsilon_set = [1,2,5]
k_set = [10]


ternary_correct_agg_prob_results = []
# gaussian_correct_agg_prob_results = []

ternary_mean_results = []
ternary_sigma_results = []
ternary_variance_results = []

gaussian_mean_results = []
gaussian_sigma_results = []
gaussian_variance_results = []

SQKR_mean_results = []
SQKR_sigma_results = []
SQKR_variance_results = []

mu_result  = []

for sparsity_index in range(len(k_set)):
    k = k_set[sparsity_index]

    gaussian_mean_results.append([])
    gaussian_sigma_results.append([])
    gaussian_variance_results.append([])
    
    ternary_mean_results.append([])
    ternary_sigma_results.append([])
    ternary_variance_results.append([])
    
    SQKR_mean_results.append([])
    SQKR_sigma_results.append([])
    SQKR_variance_results.append([])
    mu_result.append([])
    
    for epsilon_index in range(len(epsilon_set)):
        epsilon = epsilon_set[epsilon_index]
        
        gaussian_mean_results[sparsity_index].append([])
        gaussian_sigma_results[sparsity_index].append([])
        gaussian_variance_results[sparsity_index].append([])
                
        ternary_mean_results[sparsity_index].append([])
        ternary_sigma_results[sparsity_index].append([])
        ternary_variance_results[sparsity_index].append([])
                
        SQKR_mean_results[sparsity_index].append([])
        SQKR_sigma_results[sparsity_index].append([])
        SQKR_variance_results[sparsity_index].append([])
        
        mu_result[sparsity_index].append([])
        
        gaussian_aggregated = []
        gaussian_difference = []
        gaussian_variance = np.zeros(d)
        
        ternary_aggregated = []
        ternary_difference = []
        ternary_variance = np.zeros(d)
        
        SQKR_aggregated = []
        SQKR_difference = []
        SQKR_variance = np.zeros(d)
        
        
        A = (np.exp(epsilon)+2**k-1)*c_inf/(np.exp(epsilon)-1)
        B = A*d/k
        mu = 2*np.sqrt(d)*c_inf/np.sqrt(A*B-c_inf**2)
        sigma = 1/mu
        
        mu_result[sparsity_index][epsilon_index].append(mu)
        
        for mc in range(MC):
            gaussian_cum_correct_agg_prob = 0
            ternary_aggregated_value = np.zeros(d)
            gaussian_aggregated_value = np.zeros(d)
            SQKR_aggregated_value = np.zeros(d)
            for m in range(N):
                sigma_ = sigma*2*c_2
#                gaussian_value = gaussian_sparsification_with_prob(user_value[m],sigma_,A,B,d)
                gaussian_value = gaussian_addnoise(user_value[m],sigma_,d)
                gaussian_aggregated_value = np.add(gaussian_aggregated_value,gaussian_value)
                
                ternary_value = sparsification_with_prob(user_value[m],A,B,d)
                ternary_aggregated_value = np.add(ternary_aggregated_value,ternary_value)
                
                SQKR_value = SQKR(user_value[m],epsilon,k,d,c_inf)
                SQKR_aggregated_value = np.add(SQKR_aggregated_value,SQKR_value)
                
            ternary_aggregated_value = np.multiply(ternary_aggregated_value,B/N)
            gaussian_aggregated_value = np.divide(gaussian_aggregated_value,N)
            SQKR_aggregated_value = np.divide(SQKR_aggregated_value,N)
            
            
            gaussian_aggregated.append(gaussian_aggregated_value)
            ternary_aggregated.append(ternary_aggregated_value)
            SQKR_aggregated.append(SQKR_aggregated_value)
            
            gaussian_variance = np.add(gaussian_variance,np.square(np.subtract(gaussian_aggregated_value,true_value)))
            ternary_variance = np.add(ternary_variance,np.square(np.subtract(ternary_aggregated_value,true_value)))
            SQKR_variance = np.add(SQKR_variance,np.square(np.subtract(SQKR_aggregated_value,true_value)))
            


        gaussian_aggregated_mean = np.array(gaussian_aggregated).astype(float).mean(axis=0)
        gaussian_aggregated_sigma = np.array(gaussian_aggregated).astype(float).std(axis=0)
        gaussian_aggregated_variance = np.sum(gaussian_variance)/MC
        
        gaussian_mean_results[sparsity_index][epsilon_index].append(gaussian_aggregated_mean)
        gaussian_sigma_results[sparsity_index][epsilon_index].append(gaussian_aggregated_sigma)
        gaussian_variance_results[sparsity_index][epsilon_index].append(gaussian_aggregated_variance)
        
        
        ternary_aggregated_mean = np.array(ternary_aggregated).astype(float).mean(axis=0)
        ternary_aggregated_sigma = np.array(ternary_aggregated).astype(float).std(axis=0)
        ternary_aggregated_variance = np.sum(ternary_variance)/MC
        
        ternary_mean_results[sparsity_index][epsilon_index].append(ternary_aggregated_mean)
        ternary_sigma_results[sparsity_index][epsilon_index].append(ternary_aggregated_sigma)
        ternary_variance_results[sparsity_index][epsilon_index].append(ternary_aggregated_variance)
        
        
        SQKR_aggregated_mean = np.array(SQKR_aggregated).astype(float).mean(axis=0)
        SQKR_aggregated_sigma = np.array(SQKR_aggregated).astype(float).std(axis=0)
        SQKR_aggregated_variance = np.sum(SQKR_variance)/MC
        
        SQKR_mean_results[sparsity_index][epsilon_index].append(SQKR_aggregated_mean)
        SQKR_sigma_results[sparsity_index][epsilon_index].append(SQKR_aggregated_sigma)
        SQKR_variance_results[sparsity_index][epsilon_index].append(SQKR_aggregated_variance)


time2=time.time()
print(time2-time1)

np.save('recordcompareSQKR_mean0_0001_fixedA_10000mc',[epsilon_set,k_set,gaussian_mean_results,gaussian_sigma_results,gaussian_variance_results,ternary_mean_results,ternary_sigma_results,ternary_variance_results,SQKR_mean_results,SQKR_sigma_results,SQKR_variance_results])


alpha_set = [i/1000 for i in range(1001)]
beta_ternary_result = []
for sparsity_index in range(len(k_set)):
    k = k_set[sparsity_index]
    beta_ternary_result.append([])
    for epsilon_index in range(len(epsilon_set)):
        epsilon = epsilon_set[epsilon_index]
        beta_ternary = []
        for alpha in alpha_set:
            beta_ternary.append(norm.cdf(norm.ppf(1-alpha)-mu_result[sparsity_index][epsilon_index][0]))
        beta_ternary_result[sparsity_index].append(beta_ternary)


alpha_SQKR_result = []
beta_SQKR_result = []
for epsilon_index in range(len(epsilon_set)):
    epsilon_SQKR = epsilon_set[epsilon_index]
    alpha_SQKR = [0,(1-np.exp(-epsilon_SQKR))/(np.exp(epsilon_SQKR)-np.exp(-epsilon_SQKR)),(1-np.exp(-epsilon_SQKR))/(np.exp(epsilon_SQKR)-np.exp(-epsilon_SQKR)),1]
    beta_SQKR = [1,1-np.exp(epsilon_SQKR)*((1-np.exp(-epsilon_SQKR))/(np.exp(epsilon_SQKR)-np.exp(-epsilon_SQKR))),np.exp(-epsilon_SQKR)*(1-(1-np.exp(-epsilon_SQKR))/(np.exp(epsilon_SQKR)-np.exp(-epsilon_SQKR))),0]
    alpha_SQKR_result.append(alpha_SQKR)
    beta_SQKR_result.append(beta_SQKR)


fig,ax = plt.subplots()
ax.plot(alpha_set,beta_ternary_result[0][0], linestyle = 'dashed',color='blue',label=r"Ternary-$\epsilon=1$")
ax.plot(alpha_set,beta_ternary_result[0][1], linestyle = 'dashed',color='red',label=r"Ternary-$\epsilon=2$")
ax.plot(alpha_set,beta_ternary_result[0][2], linestyle = 'dashed',color='black',label=r"Ternary-$\epsilon=5$")
ax.plot(alpha_SQKR_result[0],beta_SQKR_result[0], marker = '+', linestyle = 'solid',color='blue',label=r"SQKR-$\epsilon=1$")
ax.plot(alpha_SQKR_result[1],beta_SQKR_result[1], marker = 'P', linestyle = 'solid',color='red',label=r"SQKR-$\epsilon=2$")
ax.plot(alpha_SQKR_result[2],beta_SQKR_result[2], marker = 'H', linestyle = 'solid',color='black',label=r"SQKR-$\epsilon=5$")
plt.legend(loc=4)
plt.xlabel(r'$\alpha$')
plt.ylabel(r'$f(\alpha)$')
plt.rcParams['font.size'] = 12
plt.legend(loc='center left', bbox_to_anchor=(0.6, 0.7))

















