mes_fit(A,B) = (1 - norm( A .- B ) / norm(A))*100
mes_err(A,B) = norm( A .- B ) / norm(A)
mes_RMSE(A,B) = sqrt( norm(A[:] .- B[:])^2 / length(A) )
mes_dkl(P,Q) = sum( P .* log.( P ./ Q ) ) - sum(P) + sum(Q)

function eval(T, Tr::Array)
    mes_fit_val = mes_fit(T,Tr)
    mes_dkl_val = mes_dkl(T,Tr)
    mes_err_val = mes_err(T,Tr)
    mes_RMSE_val = mes_RMSE( T, Tr )
    return mes_fit_val, mes_err_val, mes_dkl_val, mes_RMSE_val
end

function eval(T, G::Vector)
    Tr = reconst(G)
    return eval(T,Tr)
end
