function baselines(method, T_miss, W, T, tol, tmax, verbose, fstr; ml=NaN, miss_min_interval=NaN)
    if method == "HaLRTC"
        fit_score, p, reconv = run_HaLRTC(T_miss, W, T, fstr, tol=tol, tmax=tmax, verbose=verbose)
    elseif method == "SiLRTC"
        fit_score, p, reconv = run_SiLRTC(T_miss, W, T, fstr, tol=tol, tmax=tmax, verbose=verbose)
    elseif method == "SiLRTCTT"
        fit_score, p, reconv = run_SiLRTCTT(T_miss, W, T,fstr, tol=tol, tmax=tmax, verbose=verbose)
    elseif method == "PTRCRW"
        fit_score, p, reconv = run_PTRCRW(T_miss, W, T, fstr,tol=tol, tmax=tmax, verbose=verbose)
    else
        error("no method")
    end
    
    save_name = "results/mr$fstr/reconst_$method.jld2"
    save(save_name, "GT", T, "miss", T_miss, "weight", W, "reconst", reconv, "miss_interval", miss_min_interval)
    println("$save_name has been saved.")
    
    save_name = "results/mr$fstr/param_$method.pdf"
    savefig(p, save_name)
    println("$save_name has been saved.")
    
    return fit_score, reconv
end

function run_HaLRTC(T_miss, W, Tgt, fstr;tol=1.0e-5, tmax=6000, verbose=false)
    rhos = [1.0e-5, 1.0e-4, 1.0e-3, 1.0e-2, 1.0e-1, 1.0, 1.0e+1, 1.0e+2]
    miss_fits = []
    for rho in rhos
        reconv_HaLRTC = HaLRTC(deepcopy(T_miss), W, rho=rho, verbose_inv=50, verbose=verbose, tol=tol, iter_max=tmax);
        miss_fit = get_miss_fit(Tgt, reconv_HaLRTC, W)
        push!(miss_fits, miss_fit)
    end
    best_rho = rhos[argmax(miss_fits)]
    best_miss_fit = maximum(miss_fits)
    @show miss_fits, best_rho

    p = plot(rhos, miss_fits, xaxis=:log,  legend=false, frame=:box,   size=(400,400),
        ylim=(0,1), xlim=(minimum(rhos), maximum(rhos)), xlabel="ρ",   ylabel="Fit", ms=10, lc=:red, 
        msc=:red,   mc=mc, shape=mc_shape)
    
    reconv = HaLRTC(deepcopy(T_miss), W, rho=best_rho, verbose_inv=5, verbose=verbose, tol=tol);
    return best_miss_fit, p, reconv
end

function run_SiLRTC(T_miss, W, Tgt, fstr;tol=1.0e-5, tmax=6000, verbose=false)
    taus = [1.0e-2,1.0e-1,1.0e0,1.0e1,1.0e2,1.0e3,1.0e4]
    miss_fits = []
    best_tau  = 0
    for tau in taus
        reconv_SiLRTC = SiLRTC(deepcopy(T_miss), W, tau=tau,  iter_max=tmax, verbose=verbose, verbose_inv=500, tol=tol);
        miss_fit = get_miss_fit(Tgt, reconv_SiLRTC, W)
        push!(miss_fits, miss_fit)
    end
    @show miss_fits
    best_tau = taus[argmax(miss_fits)]
    best_miss_fit = maximum(miss_fits)
    
    p = plot(taus, miss_fits, xaxis=:log, legend=false, frame=:box, size=(400,400),
        ylim=(0,1), xlim=(minimum(taus), maximum(taus)), xlabel="τ", ylabel="Fit", ms=10, lc=:red, 
        msc=:red,   mc=mc, shape=mc_shape)
    
    reconv = SiLRTC(deepcopy(T_miss), W, tau=best_tau,  iter_max=tmax,  verbose=verbose, verbose_inv=1, tol=tol);
    return best_miss_fit, p, reconv
end

function run_SiLRTCTT(T_miss, W, Tgt, fstr; tol=1.0e-5, tmax=1500, verbose=false)
    fvs = [0.001, 0.01, 0.025, 0.1, 0.25, 1]
    miss_fits = []
    best_tau  = 0

    for fv in fvs
        reconv_SiLRTCTT   = SiLRTCTT!(deepcopy(T_miss), W, f=fv, iter_max=tmax,  verbose=verbose, verbose_inv=100, tol=tol);
        miss_fit = get_miss_fit(Tgt, reconv_SiLRTCTT, W)
        push!(miss_fits, miss_fit)
        @show (fv, miss_fit)
    end
    best_fv = fvs[argmax(miss_fits)]
    best_miss_fit = maximum(miss_fits)
    
    p = plot(fvs, miss_fits, xaxis=:log, legend=false, frame=:box, size=(400,400),
        ylim=(0,1), xlim=(minimum(fvs), maximum(fvs)), xlabel="f", ylabel="Fit", ms=10, lc=:red, 
        msc=:red,   mc=mc, shape=mc_shape)
    
    reconv = SiLRTCTT!(deepcopy(T_miss), W, f=best_fv,  iter_max=500,  verbose=false, verbose_inv=10, tol=1.0e-5);
    return best_miss_fit, p, reconv
end

function run_PTRCRW(T_miss, W, Tgt, fstr; tol=1.0e-5, tmax=6000, verbose=false)
    Rs = [1,2,3,4,5,6]; alpha = [0.25,0.25,0.25,0.25]; d = 2;
    miss_fits = []
    D  = ndims(T_miss)
    for r in Rs
        R = [r,r,r,r]
        reconv_PTRCRW = PTRCRW!(deepcopy(T_miss), W, R, alpha, d, verbose=verbose, tol=tol, verbose_inval=1000, iter_max=tmax);
        miss_fit = get_miss_fit(Tgt, reconv_PTRCRW, W)
        push!(miss_fits, miss_fit)
    end
    best_r = Rs[argmax(miss_fits)]
    best_miss_fit = maximum(miss_fits)
    @show miss_fits
    p = plot(Rs, miss_fits, legend=false, frame=:box, size=(400,400),
        ylim=(0,1), xlim=(minimum(Rs), maximum(Rs)), xlabel="Rank", ylabel="Fit", ms=10, lc=:red, 
        msc=:red,   mc=mc, shape=mc_shape)
    
    best_R = [best_r for i = 1:4 ]
    reconv = PTRCRW!(deepcopy(T_miss), W, best_R, alpha, d, verbose=false, tol=tol, verbose_inval=1);
    return best_miss_fit, p, reconv
end
