function [ X ] = createSparseRandomLowRankInputCommonSupport( n1,n2,rank,sparsity,singularValues )
%   Creates random X with sparse right singular vectors and common support
%
%   n1,n2           -       Dimensions of X
%   rank            -       Rank of X
%   sparsity        -       Sparsity on right singular vectors relative to n2
%   singularValues  -       Vector of wished singular vectors (optional)


    X = zeros(n1,n2);
    u = randn(n1,rank);
    v = zeros(n2,rank);
    
    sStructure = zeros(n2,1);
    r = sort(randsample(n2,floor(sparsity*n2)));
    sStructure(r) = 1;
    
    for k = 1:rank
        
        v(:,k) = sprandn(sStructure);
    
    end
        
    d2 = 0;
    
    if nargin > 4
        [d1,d2] = size(singularValues);
    end
        
    if d2 > rank
        rank = d2;
    end
    
    for i = 1:rank
        X = X + u(:,i)*v(:,i)';
    end
    
    [U,S,V] = svd(X);
    sr = randperm(rank,d2);
    s = diag(S);
    
    for i = 1:d2
        s(sr(i)) = singularValues(1,i);
    end
    
    S(1:min(n1,n2),1:min(n1,n2)) = diag(s);
    X = U*S*V';


end