%%-------------------------------------------------------------------------
% Plot phase transition diagrams, created with phase_transition.m
%%-------------------------------------------------------------------------
%
% Before running this script you need to create phase transition output by
% phase_transition.m. Then you run this script in the command window by
% 
% >> plot_phase_transition 'PATH/TO/phase_transition_output_XXX.mat' 'PATH/TO/parameter_file_PT_XXX.mat'
% 
% in the respective output folder.
%
%%-------------------------------------------------------------------------
% Authors: Christian K?mmerle (2015/8/27)
% Technical University of Munich
% Boltzmannstrasse 3, 85748 Garching, GERMANY
%
% THE CODE SUPPORTS THE RESULTS IN THE PAPER "..."
%--------------------------------------------------------------------------

function plot_results_errorbar(values_y,values_y_all,parameters,alg_names,...
    options,figure_names,varargin)


markers = {'-x', '-+', '-*', '-o','-x', '-s', '-d', '-^', '-v', ...
           '-x', '-+', '-*', '-o','-x', '-s', '-d', '-^', '-v'};
       
if nargin >= 5
    custom_options = varargin{1};
    if isfield(custom_options,'markers')
        markers =  custom_options.markers;
    end
    if isfield(custom_options,'ColorOrderIndices')
        ColorOrderIndices =  custom_options.ColorOrderIndices;
    end
    if isfield(custom_options,'which_algos')
        which_algos = custom_options.which_algos;
        nr_algos_used = length(which_algos);
        select_algos = 1;
    else
        select_algos = 0;
    end
end
if not(isfield(options,'linewidth'))
    options.linewidth = 2;
end
if not(isfield(options,'capsizefac'))
    options.capsizefac = 2;
end
fdnames = fieldnames(parameters);
para1           =   fdnames{1};
values1         =   parameters.(para1);

nr_algos=length(alg_names);     
colorscheme = [0.00000 0.44700 0.74100
               0.85000 0.32500 0.09800
               0.92900 0.69400 0.12500
               0.49400 0.18400 0.55600
               0.46600 0.67400 0.18800
               0.30100 0.74500 0.93300
               0.63500 0.07800 0.18400
               0.08000 0.39200 0.25100];
set(groot,'defaultAxesColorOrder',colorscheme)
% [m_len,nr_measmatr,nr_algos]=size(error_l2);
% colorscheme= hsv(7);
% cpper=copper(5);
% colors=cell(1,20);
% markerstyle=cell(1,20);
% lines =cell(1,14);
% colors{1}='k';  markerstyle{1}='*';
% 
% lines{1}='-';
% colors{2}='r';  markerstyle{2}='o';
% 
% lines{2}=':';
% colors{3}='b';  markerstyle{3}='^';
% lines{3}='-.';
% colors{4}='g';      lines{4}='--';
% colors{5}='m';      lines{5}=':';
% colors{6}='c';      lines{6}=':';
% colors{7}=colorscheme(4,:);      lines{7}=':';
% colors{8}='m';        lines{8}='-';
% colors{9}=cpper(3,:);         lines{9}='-';
% colors{10}=colorscheme(3,:);        lines{10}='-';
% colors{11}=[255/255,165/255,0/255];lines{11}='-';  %orange
% colors{12}=colorscheme(4,:);  lines{12}='-';
% colors{13}=colorscheme(6,:);        lines{13}='-';
% colors{14}=colorscheme(7,:);        lines{14}='-';
% colors{15}='o--m';
% colors{16}='d-.k';
% colors{17}='d-.r';
% colors{18}='d-.g';
% colors{19}='d-.b';
% colors{20}='d-.m';
if not(select_algos)
    nr_algos_used = nr_algos;
    which_algos = [1:nr_algos];
end
legendInfo=cell(1,nr_algos_used);%cell(1,nr_measmatr*nr_algos_used);
figure 
box on
for i=1:nr_algos_used
    values_y_c = [values_y(which_algos(i),:)];
    nr_paras = size(values_y,2);
    stdevs = zeros(1,nr_paras);
    lq = zeros(1,nr_paras);
    uq = zeros(1,nr_paras);
    med = zeros(1,nr_paras);
    for j = 1:nr_paras
        stdevs(j) = get_stdd(values_y(which_algos(i),j),values_y_all{which_algos(i),j});
        med(j) = get_med(values_y(which_algos(i),j),values_y_all{which_algos(i),j});
        lq(j) = get_lq(values_y(which_algos(i),j),values_y_all{which_algos(i),j});
        uq(j) = get_uq(values_y(which_algos(i),j),values_y_all{which_algos(i),j});    
    end
%     values_y_c(find(isnan(values_y_c))) = 1e4;
    h = errorbar(values1,values_y_c,lq,uq,'LineWidth',options.linewidth,'CapSize',options.capsizefac*options.linewidth);
    if isfield(options,'logy') && options.logy
        set(gca,'yscale','log') 
    end
    if isfield(options,'logx') && options.logx
        set(gca,'xscale','log')
    end
    hold on;
    if isfield(custom_options,'ColorOrderIndices')
        set(gca,'ColorOrderIndex',ColorOrderIndices(i));
    end
    legendInfo{i}=alg_names{which_algos(i)};
    %alpha = 0.4;   
    % Set transparency (undocumented)
    %set([h.Bar, h.Line], 'ColorType', 'truecoloralpha', 'ColorData', [h.Line.ColorData(1:3); 255*alpha])
end
% for i=1:nr_algos_used
%     for ll=1:nr_measmatr
%         error_l2_c = [error_l2{:,ll,which_algos(i)}];
%         error_l2_c(find(isnan(error_l2_c))) = 1e4;
%         semilogy(mvec,error_l2_c,'Color',colors{i},'LineStyle',lines{i},...
%             'LineWidth',2,...
%             'Marker',markerstyle{ll},'MarkerSize',10,...
%             'MarkerEdgeColor',colors{i});
%         legendInfo{(i-1)*nr_measmatr+ll}=alg_names{which_algos(i)};
%             %', A i.i.d. ',name_measmat{ll}];
%         hold on
% %         else
% %             str=get(h,'string');% get the previous legend
% %             new_leg=[l1_types{i},' using ',name_measmat{ll},' measurements'];  % your new legend
% %             h=legend([str new_leg]);  % concatenate the new and the previous legend
%         
%     end
% end
% set(gca, 'YScale', 'log')
legend(legendInfo,'Interpreter','Latex','FontSize',15);

% ylabel('relative reconstruction error $\|\hat{x}-x_0\|_{2}/\|x_0\|_{2}$','Interpreter','Latex','FontSize',17)
% xlabel('Number of measurements $m$','Interpreter','Latex','FontSize',17);
ax = gca;
ax.YAxisLocation = 'right';
for l=1:nr_algos_used
    if isfield(custom_options,'ColorOrderIndices')
        ax.Children(nr_algos+1-l).Color = colorscheme(l,:);
    end
    if isfield(custom_options,'markersize')
        ax.Children(nr_algos_used+1-l).MarkerSize = custom_options.markersize(l);
    end
end

if isfield(options,'xlim')
    xlim([options.xlim(1) options.xlim(end)])
end
if isfield(options,'ylim')
    ylim([options.ylim(1) options.ylim(end)])
end
if isfield(options,'yticks')
   yticks(options.yticks) 
end
if isfield(options,'ylabels')
   ax.YTickLabels = options.ylabels; 
end

if isfield(figure_names,'xname')
    xlabel(figure_names.xname,'interpreter','Latex');
else
    xlabel(para1,'interpreter','Latex');
end
if isfield(figure_names,'yname')
    ylabel(figure_names.yname,'interpreter','Latex');
end
% yyaxis right
% ylabel(yname,'interpreter','Latex');
if isfield(figure_names,'titlestr')
%     titlestr=['d1=',num2str(problem.d1),', d2=',num2str(problem.d1),...
%     ', r=',num2str(problem.r),', kappa=',num2str(problem.cond_nr)];
%     title(figure_names.titlestr)
    set(gcf,'name',figure_names.titlestr)
end

end