function [meas,degs] = compute_measurements_LRRS_sparsitys(Example,sparsitys,...
    ms_vec,rho_min,rho_max,varargin)

degs = zeros(1,length(sparsitys));
for ii = 1:length(sparsitys)
    K1 = sparsitys(ii);
    [~,~,df_combined,~,~,~,~,~,~] = degfreedom(Example.prob.n1,Example.prob.n2, ...
    K1,Example.prob.n2,Example.prob.r);
    degs(ii) = df_combined;
end
if isempty(ms_vec)
    meas=cell(1,length(sparsitys));
else
    if nargin > 5
        min_max_meas = varargin{1};
    else
        min_max_meas = 0;
    end

    % ms_vec = [75:25:800,850:50:2000,2100:100:5000];

    meas=cell(1,length(sparsitys));
    for ii=1:length(sparsitys)
        ind_upper = max((ms_vec< rho_max*degs(ii)),(ms_vec <= min_max_meas));
        ind_lower = ms_vec>rho_min*degs(ii);
        ind = find(min(ind_lower,ind_upper));
        meas{ii} = ms_vec(ind);
    end
end
end