import math

def discrete_laplace(rng, inv_scale, size = None):
    """
    Returns a numpy array with the given size, or a scalar if None, consisting
    of samples from the distribution over the integers with probability mass
    function of x proportional to exp(-inv_scale * x).

    rng should be an instance of numpy.random.Generator.
    """
    p = 1 - math.exp(-inv_scale)
    return rng.geometric(p, size = size) - rng.geometric(p, size = size)
