import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    input_grid = np.array(input_grid)
    output_grid = np.zeros_like(input_grid)
    grid_size = 3
    max_blue_count = 0
    max_blue_grid = None

    # Find all 3x3 grids
    for i in range(0, input_grid.shape[0], grid_size):
        for j in range(0, input_grid.shape[1], grid_size):
            if np.any(input_grid[i:i+grid_size, j:j+grid_size] != black):
                # Count blue pixels in each 3x3 grid
                blue_count = np.sum(input_grid[i:i+grid_size, j:j+grid_size] == blue)
                if blue_count > 0:
                    # Find the 3x3 grid with the most blue pixels
                    if blue_count > max_blue_count:
                        max_blue_count = blue_count
                        max_blue_grid = input_grid[i:i+grid_size, j:j+grid_size]

    return max_blue_grid