import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find all not black and not grey pixels
    not_black_or_grey = np.where((input_grid != black) & (input_grid != grey))
    # Find the minimum and maximum row and column indices of not black or grey pixels
    min_row, max_row = np.min(not_black_or_grey[0]), np.max(not_black_or_grey[0])
    min_col, max_col = np.min(not_black_or_grey[1]), np.max(not_black_or_grey[1])
    # Find the 3x3 area that covers all not black or grey pixels
    start_row = max(min_row, max(min_row, max_row - 2))
    end_row = min(max_row, min(max_row, min_row + 2))
    start_col = max(min_col, max(min_col, max_col - 2))
    end_col = min(max_col, min(max_col, min_col + 2))
    # Copy the 3x3 area onto the input grid with the center pixel as the center of the new 3x3 area
    output_grid = np.copy(input_grid)
    output_grid[start_row:end_row+1, start_col:end_col+1] = input_grid[start_row:end_row+1, start_col:end_col+1]
    # Find the center pixel
    center_row, center_col = np.where(output_grid == grey)
    center_row, center_col = center_row[0], center_col[0]
    # Find the new 3x3 area whose center is the grey pixel
    new_start_row = max(center_row - 1, 0)
    new_end_row = min(center_row + 1, output_grid.shape[0] - 1)
    new_start_col = max(center_col - 1, 0)
    new_end_col = min(center_col + 1, output_grid.shape[1] - 1)
    # Copy the old 3x3 area to the new 3x3 area
    output_grid[new_start_row:new_end_row+1, new_start_col:new_end_col+1] = input_grid[start_row:end_row+1, start_col:end_col+1]
    return output_grid