import numpy as np

(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: find center coordinates of blue squares
    centers = []
    for i in range(input_grid.shape[0]-1):
        for j in range(input_grid.shape[1]-1):
            if input_grid[i,j] == blue and input_grid[i+1,j] == blue and input_grid[i,j+1] == blue:
                centers.append((i+2, j+2))

    # Step 2: change non-blue pixels in same row/column to pink
    for center in centers:
        i, j = center
        for k in range(input_grid.shape[0]):
            if input_grid[k,j] != blue:
                input_grid[k,j] = pink
        for k in range(input_grid.shape[1]):
            if input_grid[i,k] != blue:
                input_grid[i,k] = pink

    # Step 3: return modified image
    return input_grid