import numpy as np

def main(input_grid):
    # Find all blocks of zero element
    zero_blocks = []
    visited = np.zeros_like(input_grid)
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == 0 and visited[i][j] == 0:
                zero_block = []
                dfs(i, j, input_grid, visited, zero_block)
                zero_blocks.append(zero_block)
    
    # Find the largest and smallest blocks
    largest_blocks = []
    smallest_blocks = []
    max_size = 0
    min_size = input_grid.size
    for block in zero_blocks:
        size = len(block)
        if size > max_size:
            max_size = size
            largest_blocks = [block]
        elif size == max_size:
            largest_blocks.append(block)
        if size < min_size:
            min_size = size
            smallest_blocks = [block]
        elif size == min_size:
            smallest_blocks.append(block)
    
    # Replace largest blocks with int 1 and smallest blocks with int 8
    output_grid = np.copy(input_grid)
    for block in largest_blocks:
        for i, j in block:
            output_grid[i][j] = 1
    for block in smallest_blocks:
        for i, j in block:
            output_grid[i][j] = 8
    
    return output_grid

def dfs(i, j, input_grid, visited, zero_block):
    if i < 0 or i >= input_grid.shape[0] or j < 0 or j >= input_grid.shape[1]:
        return
    if input_grid[i][j] != 0 or visited[i][j] == 1:
        return
    visited[i][j] = 1
    zero_block.append((i, j))
    dfs(i+1, j, input_grid, visited, zero_block)
    dfs(i-1, j, input_grid, visited, zero_block)
    dfs(i, j+1, input_grid, visited, zero_block)
    dfs(i, j-1, input_grid, visited, zero_block)
    