import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the largest black square or rectangle
    max_area = 0
    max_top = 0
    max_left = 0
    rows, cols = input_grid.shape
    for top in range(rows):
        for left in range(cols):
            if input_grid[top, left] == black:
                # Found a black square or rectangle
                bottom = top
                while bottom < rows and input_grid[bottom, left] == black:
                    right = left
                    while right < cols and input_grid[top:bottom+1, left:right+1].max() == black:
                        # Calculate the area of the square or rectangle
                        area = (bottom - top + 1) * (right - left + 1)
                        if area > max_area:
                            max_area = area
                            max_left = left
                            max_top = top
                        right += 1
                    bottom += 1
    # Create the output grid
    output_grid = np.copy(input_grid)
    if max_area > 0:
        output_grid[max_top:max_top+int(max_area**(1/2)), max_left:max_left+int(max_area**(1/2))] = pink
    return output_grid
