import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the row of the topest grey pixel and the row of the topeset teal pixel
    grey_row = None
    teal_row = None
    for i in range(input_grid.shape[0]):
        if grey in input_grid[i]:
            grey_row = i
        if teal in input_grid[i]:
            teal_row = i
    # Compute the abs dist between the two rows
    abs_dist = abs(grey_row - teal_row)
    # Create the output grid
    output_grid = np.zeros((3, 3), dtype=int)
    # Color the output grid with teal according to the abs dist
    row = 0
    col = 0
    for i in range(abs_dist):
        output_grid[row][col] = teal
        if col == 2:
            row += 1
            col = 2
        elif col == 0:
            row += 1
            col = 0
        else:
            if row % 2 == 0:
                col -= 1
            else:
                col += 1
    return output_grid
