import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get unique colors in input grid except for black
    unique_colors = np.unique(input_grid[np.where(input_grid != black)])

    # Calculate size of output grid
    output_size = input_grid.shape[0] * unique_colors.shape[0]

    # Create output grid
    output_grid = np.zeros((output_size, output_size))

    # Loop through input grid and place each block in its own space in output grid
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            color = input_grid[i][j]
            if color == black:
                continue
            row_start = i * unique_colors.shape[0]
            row_end = row_start + unique_colors.shape[0]
            col_start = j * unique_colors.shape[0]
            col_end = col_start + unique_colors.shape[0]
            output_grid[row_start:row_end, col_start:col_end] = color

    return output_grid
