import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Copy the first 4 rows of the input grid to the output grid
    output_grid = input_grid[:4].copy()
    # Color the black pixels of the output grid green
    output_grid[output_grid == black] = green
    # Color the orange pixels of the output grid black
    output_grid[output_grid == orange] = black

    # Get the bottom 4x4 grid where the red pixels are
    bottom_grid = input_grid[-4:]
    # Find the green pixels in the output grid that have a corresponding red pixel in the bottom grid
    green_pixels = np.where((output_grid == green) & (bottom_grid == red))
    # Change those green pixels to black
    output_grid[green_pixels] = black

    # Resize the output grid to 4x4
    output_grid = output_grid[:4, :4]

    return output_grid