import numpy as np

# Define color codes
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Traverse input_grid and record non-black pixels
    non_black_pixels = []
    for i in range(3):
        for j in range(3):
            if input_grid[i][j] != black:
                non_black_pixels.append((i, j, input_grid[i][j]))

    # Step 2: Create a completely black 6x6 image matrix
    output_grid = np.zeros((6, 6), dtype=int)

    # Step 3: Traverse non-black pixels and color bottom-right 45-degree direction
    for pixel in non_black_pixels:
        i, j, c = pixel
        for k in range(1, 4):
            if i+k < 6 and j+k < 6:
                output_grid[i+k][j+k] = c

    # Step 4: Cover 3x3 region on output_grid with input_grid
    output_grid[:3, :3] = input_grid

    return output_grid
    