import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the shape of the input grid
    rows, cols = input_grid.shape
    
    # Create an empty output grid with double the number of columns
    output_grid = np.zeros((rows, cols*2), dtype=int)
    
    # Iterate over each row in the input grid
    for i in range(rows):
        # Copy the values from the input grid to the left half of the output grid
        output_grid[i, :cols] = input_grid[i]
        
        # Reverse the values in the row and copy them to the right half of the output grid
        output_grid[i, cols:] = input_grid[i, ::-1]
    
    return output_grid