import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the most frequent color in each row
    row_colors = [np.bincount(row).argmax() for row in input_grid]

    # Check if the most frequent color in each row occurs less than 50% of the time
    if all(np.bincount(row)[color] < len(row) / 2 for color, row in zip(row_colors, input_grid)):
        # Rotate the input grid by 90 degrees
        input_grid = np.rot90(input_grid)
        # Recalculate the most frequent color in each row
        row_colors = [np.bincount(row).argmax() for row in input_grid]

    # Color each row with the most frequent color
    output_grid = np.array([np.full_like(row, color) for color, row in zip(row_colors, input_grid)])

    # If the input grid was rotated, rotate the output grid back
    if input_grid.shape != output_grid.shape:
        output_grid = np.rot90(output_grid, k=4-input_grid.ndim)

    return output_grid