import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Split the input grid into two 3x3 sub grids
    sub_grids = [input_grid[:, :3], input_grid[:, 3:]]
    copy_sub_grid = sub_grids[0].copy()
    
    # Copy non-black pixels from other sub grids to the copy sub grid
    for sub_grid in sub_grids[1:]:
        copy_sub_grid[sub_grid != black] = sub_grid[sub_grid != black]
    
    # Turn all non-black pixels into pink
    copy_sub_grid[copy_sub_grid != black] = pink
    
    return copy_sub_grid