function [ output_args ] = plotSig( values, shuffledValues, pvalThreshold )

output_args = [];

pvals = pValGauss1D(values, shuffledValues, 0);
top = max(values);
bottom = min(values);
bottom = min(bottom, 0);

inSig = 0;
sig = [];
last = 0;
count = 0;
for i = 1:size(values, 1)
    if (pvals(i) < pvalThreshold)
        if (~inSig)
            last = i;
            inSig = 1;
        end
    else
        if (inSig && last < i - 1)
            sig(count + 1, 1) = last;
            sig(count + 1, 2) = i - 1;
            inSig = 0;
            count = count + 1;
        end
    end
end

hold on;
for i = 1:size(sig, 1)
    h = area([sig(i, 1) sig(i, 2)], [top top]);
    h.EdgeColor = [0.9 0.9 0.9];
    h.FaceColor = [0.9 0.9 0.9];
    h.BaseValue = bottom;
end

end

