function [ output_args ] = plotPercAndSigDFI( vals, valsSh, percVals, percValsBot, color, offset, endTime, xlab, ylab, pvalThreshold, titl )
    debase = min(vals(offset:(offset + 20)));
    output_args = [];
    x = (offset:endTime) - offset + 1;
    h = fill([x fliplr(x)], [percVals(offset:endTime)' - debase fliplr(percValsBot(offset:endTime)' - debase)], color);
    h.EdgeColor = color;
    hold on;
    plot(vals(offset:endTime) - debase, 'k');
    xlabel(xlab);
    ylabel(ylab);
    title(titl);
    xlim([1 (endTime - offset + 1)]);
    bottom = min(min(vals(offset:endTime)), min(percValsBot(offset:endTime)));
    top = max(max(vals(offset:endTime)), max(percVals(offset:endTime)));
    y = bottom + 1.2 * (top - bottom);
    yl = top - 1.2 * (top - bottom);
    
%     pvals = pValGauss1D(vals(offset:endTime), valsSh(offset:endTime, :), 0);
%     inSig = 0;
%     sig = [];
%     last = 0;
%     count = 0;
%     for i = 1:size(vals(offset:endTime), 1)
%         if (pvals(i) < pvalThreshold)
%             if (~inSig)
%                 last = i;
%                 inSig = 1;
%             end
%         else
%             if (inSig && last < i - 1)
%                 sig(count + 1, 1) = last;
%                 sig(count + 1, 2) = i - 1;           
%                 count = count + 1;
%             end
%             inSig = 0;
%         end
%     end
% 
%     hold on;
%     for i = 1:size(sig, 1)
%         line([sig(i, 1) sig(i, 2)], [y y], 'Color', 'k', 'LineWidth', 1);
%     end
%     
%     pvals = pValGauss1D(-vals(offset:endTime), -valsSh(offset:endTime, :), 0);
%     inSig = 0;
%     sig = [];
%     last = 0;
%     count = 0;
%     for i = 1:size(vals(offset:endTime), 1)
%         if (pvals(i) < pvalThreshold)
%             if (~inSig)
%                 last = i;
%                 inSig = 1;
%             end
%         else
%             if (inSig && last < i - 1)
%                 sig(count + 1, 1) = last;
%                 sig(count + 1, 2) = i - 1;           
%                 count = count + 1;
%             end
%             inSig = 0;
%         end
%     end
% 
%     hold on;
%     for i = 1:size(sig, 1)
%         line([sig(i, 1) sig(i, 2)], [yl yl], 'Color', 'k', 'LineWidth', 1);
%     end

end

