function [new_cFIT] = Compute_cFIT(S,X,Z,hY,Y,FITS,FITY,DoQe)


% FITS, FITY are those based on which we choose the lattice
% FITSval, FITYval are the values from which we subtract the FIT_uniqueZ
% atom. FIT and FITval might only differ when doing the permutations for
% the null hypothesis

if nargin < 9
    FITSval = FITS;
    FITYval = FITY;
end
if DoQe == 0
    FITSQe = -1;
    FITYQe = -1;
end

FIT_S_uniqueZ = computeInfQuantities_2dsource_new(S, X, Y, hY, Z, DoQe);                     
FIT_Y_uniqueZ = computeInfQuantities_2dsource_new(Y, X, S, hY, Z, DoQe);   

new_cFIT = min(FITSval , FITYval)-min(FIT_S_uniqueZ,FIT_Y_uniqueZ);

end