function h = static_network_plot_v4(G,cols)
% Add total weight arrow

    x = [1 3 5 7];
    y = [1 1 1 1];
    h=plot(G,'XData',x,'YData',y,'NodeColor',cols);
    h.MarkerSize = 7.5;
    lineWeights = mat2cell((3/(max(G.Edges.Weight)))*G.Edges.Weight,numel(G.Edges.Weight),1);
    set(h,{'LineWidth'},lineWeights)
    
    fwd_id = [1,2,3,5,6,9]; % id of edges to be removed (fwd)
    fbk_id = setdiff(1:size(G.Edges,1),fwd_id);
    fbkG = rmedge(G,fwd_id);
    
    highlight(h,fbkG,'EdgeColor','r')
    
    %h.LineWidth = 2.5;
    h.NodeFontSize = 10;
    h.ArrowSize = 10;
    % hide axes:
    set(gca,'XTickLabel',{' '})
    set(gca,'YTickLabel',{' '})
    set(gca,'YTick',[])
    set(gca,'XTick',[])
    
    % Draw overall arrows
    hold on
    
    drawArrow = @(x,y,varargin) quiver( x(1),y(1),x(2)-x(1),y(2)-y(1),0, varargin{:} ) ;      
    
    arrayWeights = cell2mat(lineWeights);
    
    % Arrows coordinates
    x1 = [7 1];
    y1 = [1.5 1.5];
    tmpW1 = sum(arrayWeights(fbk_id));
    
    x2 = [1 7];
    y2 = [0.5 0.5];
    tmpW2 = sum(arrayWeights(fwd_id));
    
    [val,maxId]=max([tmpW1,tmpW2]);
    if maxId == 1 %fwd larger than fbk
        W1 = 5;
        W2 = 5*(tmpW2/tmpW1);
        x3 = [7 1];
        y3 = [1.25 1.25];
        W3 = tmpW1-tmpW2;
    elseif maxId == 2 %fbk larger than fwd
        W1 = 5*(tmpW1/tmpW2);
        W2 = 5;
        x3 = [1 7];
        y3 = [0.75 0.75];
        W3 = tmpW2-tmpW1;
    end
    
%     drawArrow(x1,y1,'linewidth',W1,'color','r'); 
%     drawArrow(x2,y2,'linewidth',W2,'color','b'); 
    drawArrow(x3,y3,'linewidth',W3,'color','g'); 

end

