function plot_early_vs_late_specific_Freq_Dir(sessDirectTransf,selFreq,selDir,selInfo,params,glm_pred,sel_time_window)

% All ROIs
figure()

for freqIdx = 1:numel(selFreq)
    freqLab = selFreq{freqIdx};
    dirLab = selDir{freqIdx};
    infoLab = selInfo{freqIdx};
    
    subplot(1,2,freqIdx)
    hold on
    if strcmp(params.fwd_fbk_pooling,'mean')
        meas1 = nanmean(sessDirectTransf.early.(infoLab).(freqLab).allROIs.(dirLab),2);
        error1 = std(meas1)/sqrt(params.nSubj);
        meas2 = nanmean(sessDirectTransf.late.(infoLab).(freqLab).allROIs.(dirLab),2);
        error2 = std(meas2)/sqrt(params.nSubj);
        
        bar(1,mean(meas1))
        bar(2,mean(meas2))
        errorbar(1,mean(meas1),error1,'k')
        errorbar(2,mean(meas2),error2,'k')
        
        measures=[meas1; meas2];
    elseif strcmp(params.fwd_fbk_pooling,'sum')
        meas1 = sum(sessDirectTransf.early.(infoLab).(freqLab).allROIs.(dirLab),2,'omitnan');
        error1 = std(meas1)/sqrt(params.nSubj);
        meas2 = sum(sessDirectTransf.late.(infoLab).(freqLab).allROIs.(dirLab),2,'omitnan');
        error2 = std(meas2)/sqrt(params.nSubj);
        
        bar(1,mean(meas1))
        bar(2,mean(meas2))
        errorbar(1,mean(meas1),error1,'k')
        errorbar(2,mean(meas2),error2,'k')
        
        measures=[meas1; meas2];
    end
    maxY = max([mean(meas1)+error1,mean(meas2)+error2]);
    
    tbl = table(measures,glm_pred.subjects_idxs',glm_pred.conditions','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'measures~Cond + (1|Subj)', 'Distribution', 'normal');
    pval_glme =  model.Coefficients.pValue(2);
    pvalues_plot(pval_glme,1.5,maxY,maxY/10,maxY/100,14,1,'k',0)
    set(gca, 'XTick', [1 2], 'XTickLabel', {'early','late'}, 'fontsize', 12)
    title([freqLab,' ',dirLab])
end
sgtitle(['Early (T=[',num2str(sel_time_window.early(1)),',',num2str(sel_time_window.early(2)),']s) vs late (T=[',num2str(sel_time_window.late(1)),',',num2str(sel_time_window.late(2)),']s) comparison, all ROIs'])

% Visual ROIs
figure()

for freqIdx = 1:numel(selFreq)
    freqLab = selFreq{freqIdx};
    dirLab = selDir{freqIdx};
    infoLab = selInfo{freqIdx};
    
    subplot(1,2,freqIdx)
    hold on
    if strcmp(params.fwd_fbk_pooling,'mean')
        meas1 = nanmean(sessDirectTransf.early.(infoLab).(freqLab).visROIs.(dirLab),2);
        error1 = std(meas1)/sqrt(params.nSubj);
        meas2 = nanmean(sessDirectTransf.late.(infoLab).(freqLab).visROIs.(dirLab),2);
        error2 = std(meas2)/sqrt(params.nSubj);
        
        bar(1,mean(meas1))
        bar(2,mean(meas2))
        errorbar(1,mean(meas1),error1,'k')
        errorbar(2,mean(meas2),error2,'k')
        
        measures=[meas1; meas2];
    elseif strcmp(params.fwd_fbk_pooling,'sum')
        meas1 = sum(sessDirectTransf.early.(infoLab).(freqLab).visROIs.(dirLab),2,'omitnan');
        error1 = std(meas1)/sqrt(params.nSubj);
        meas2 = sum(sessDirectTransf.late.(infoLab).(freqLab).visROIs.(dirLab),2,'omitnan');
        error2 = std(meas2)/sqrt(params.nSubj);
        
        bar(1,mean(meas1))
        bar(2,mean(meas2))
        errorbar(1,mean(meas1),error1,'k')
        errorbar(2,mean(meas2),error2,'k')
        
        measures=[meas1; meas2];
    end
    maxY = max([mean(meas1)+error1,mean(meas2)+error2]);
    
    tbl = table(measures,glm_pred.subjects_idxs',glm_pred.conditions','VariableNames',{'measures','Subj','Cond'});
    model = fitglme(tbl,'measures~Cond + (1|Subj)', 'Distribution', 'normal');
    pval_glme =  model.Coefficients.pValue(2);
    pvalues_plot(pval_glme,1.5,maxY,maxY/10,maxY/100,14,1,'k',0)
    set(gca, 'XTick', [1 2], 'XTickLabel', {'early','late'}, 'fontsize', 12)
    title([freqLab,' ',dirLab])
end
sgtitle(['Early (T=[',num2str(sel_time_window.early(1)),',',num2str(sel_time_window.early(2)),']s) vs late (T=[',num2str(sel_time_window.late(1)),',',num2str(sel_time_window.late(2)),']s) comparison, visual ROIs'])

end