% v2 + added group level comparisons

function [directTransf, sessDirectTransf, subjDirectTransf] = compute_fwd_fbk_transfer_v4(connStrenghts,sessConnStrenghts,relativeOrder,computedROIs,computedROIsGroupsLab,params,sort_idxs)
allGroups = unique(computedROIsGroupsLab(sort_idxs),'stable'); % groups labels ordered according to hierarchy

directTransf = []; % indexed of forward/feedback information transmission for each ROI
sessDirectTransf = []; % Notice directTransf is the average of subjDirectTransf across sess

% Should I take the mean or the sum when computing these idxs? At the
% moment I'm averaging across forward/feedback regions
for freqIdx = 1:numel(params.frequency_bands)
    freqLab = params.frequency_bands{freqIdx};
    for infoIdx = 1:numel(params.info_type)
        infoLab = params.info_type{infoIdx};
        directTransf.(infoLab).(freqLab).allROIs.forward = [];
        directTransf.(infoLab).(freqLab).allROIs.feedback = [];
        sessDirectTransf.(infoLab).(freqLab).allROIs.forward = [];
        sessDirectTransf.(infoLab).(freqLab).allROIs.feedback = [];
        
        % directionality transf measures within visual network
        directTransf.(infoLab).(freqLab).visROIs.forward = [];
        directTransf.(infoLab).(freqLab).visROIs.feedback = [];
        sessDirectTransf.(infoLab).(freqLab).visROIs.forward = [];
        sessDirectTransf.(infoLab).(freqLab).visROIs.feedback = [];
        
        for roiIdx = 1:numel(computedROIs)
            roiLab = computedROIs{roiIdx};
            emitted_info=connStrenghts.(infoLab).(freqLab)(roiIdx,:);
            subj_emitted_info=squeeze(sessConnStrenghts.(infoLab).(freqLab)(:,roiIdx,:));
            
            ROIvalidName=(matlab.lang.makeValidName(roiLab));
            
            if isfield(relativeOrder.all.(ROIvalidName).idxs,'forward') % control that the selected ROIs has some forward ROIs
                directTransf.(infoLab).(freqLab).(ROIvalidName).forward = emitted_info(relativeOrder.all.(ROIvalidName).idxs.forward);
                sessDirectTransf.(infoLab).(freqLab).(ROIvalidName).forward = subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.forward);
                directTransf.(infoLab).(freqLab).allROIs.forward = [directTransf.(infoLab).(freqLab).allROIs.forward, emitted_info(relativeOrder.all.(ROIvalidName).idxs.forward)];
                sessDirectTransf.(infoLab).(freqLab).allROIs.forward = [sessDirectTransf.(infoLab).(freqLab).allROIs.forward, subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.forward)];
            end
            if isfield(relativeOrder.all.(ROIvalidName).idxs,'feedback') % control that the selected ROIs has some feedback ROIs
                directTransf.(infoLab).(freqLab).(ROIvalidName).feedback = emitted_info(relativeOrder.all.(ROIvalidName).idxs.feedback);
                sessDirectTransf.(infoLab).(freqLab).(ROIvalidName).feedback = subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.feedback);
                directTransf.(infoLab).(freqLab).allROIs.feedback = [directTransf.(infoLab).(freqLab).allROIs.feedback, emitted_info(relativeOrder.all.(ROIvalidName).idxs.feedback)];
                sessDirectTransf.(infoLab).(freqLab).allROIs.feedback = [sessDirectTransf.(infoLab).(freqLab).allROIs.feedback, subj_emitted_info(:,relativeOrder.all.(ROIvalidName).idxs.feedback)];
            end
            
        end
        subjDirectTransf.(infoLab).(freqLab).allROIs.forward=temporal_rebinning(sessDirectTransf.(infoLab).(freqLab).allROIs.forward',4,'mean',4);
        subjDirectTransf.(infoLab).(freqLab).allROIs.feedback=temporal_rebinning(sessDirectTransf.(infoLab).(freqLab).allROIs.feedback',4,'mean',4);
        
        tmpSessConn = permute(sessConnStrenghts.(infoLab).(freqLab),[2 1 3]);
        subjConnStrenghts = temporal_rebinning(tmpSessConn,4,'mean',4);
        subjConnStrenghts = permute(subjConnStrenghts,[2 1 3]);
        subjConnStrenghts = subjConnStrenghts(:,sort_idxs,sort_idxs);
        
        for geIdx = 1:numel(allGroups) % emitter group
            g1_idxs = strcmp(computedROIsGroupsLab(sort_idxs),allGroups{geIdx});
            for grIdx = 1:numel(allGroups) % receiver group
%                 groupPairLab = [allGroups{geIdx},'_',allGroups{grIdx}];
                g2_idxs = strcmp(computedROIsGroupsLab(sort_idxs),allGroups{grIdx});
                
                all_idxs = g1_idxs | g2_idxs;
                partialConn = nan(params.nSubj,sum(all_idxs),sum(all_idxs));
                tmp_g1 = 1:sum(g1_idxs);
                if geIdx ~= grIdx
                    tmp_g2 = sum(g1_idxs)+1:sum(g1_idxs)+sum(g2_idxs);
                elseif geIdx == grIdx
                    tmp_g2 = tmp_g1;
                end
                partialConn(:,tmp_g1,tmp_g2) = subjConnStrenghts(:,g1_idxs,g2_idxs);
                partialConn(:,tmp_g2,tmp_g1) = subjConnStrenghts(:,g2_idxs,g1_idxs);
                
                for subjIdx = 1:params.nSubj
                    M = squeeze(partialConn(subjIdx,:,:));
                    
                    % Get upper triangular (feedforward) values
                    Mt = M.';
                    m  = (1:size(Mt,1)).' > (1:size(Mt,2));
                    tmpForwardLinks = Mt(m);
                    tmpForwardLinks = tmpForwardLinks(~isnan(tmpForwardLinks));
                    if isempty(tmpForwardLinks)
                        tmpForwardLinks = 0;
                    end
                    subjDirectTransf.(infoLab).(freqLab).groupPairs.forward{geIdx,grIdx}(:,subjIdx) = tmpForwardLinks;

                    % Get lower triangular (feedback) values
                    Mt = M.';
                    m  = (1:size(Mt,1)).' < (1:size(Mt,2));
                    tmpFeedbackLinks = Mt(m);
                    tmpFeedbackLinks = tmpFeedbackLinks(~isnan(tmpFeedbackLinks));
                    if isempty(tmpFeedbackLinks)
                        tmpFeedbackLinks = 0;
                    end
                    subjDirectTransf.(infoLab).(freqLab).groupPairs.feedback{geIdx,grIdx}(:,subjIdx) = tmpFeedbackLinks;
                end
            end
        end
    end
end

end