% Compute MI null hypothesis

function infovals = computeMI_v1(bNeural,stim,choice,opts,shIdxs)

infovals.MI_lowS = zeros(1,opts.timeSteps);
infovals.MI_lowC = zeros(1,opts.timeSteps);
infovals.MI_highS = zeros(1,opts.timeSteps);
infovals.MI_highC = zeros(1,opts.timeSteps);

infovals.MIsh_lowS = zeros(opts.timeSteps,opts.nShuff);
infovals.MIsh_lowC = zeros(opts.timeSteps,opts.nShuff);
infovals.MIsh_highS = zeros(opts.timeSteps,opts.nShuff);
infovals.MIsh_highC = zeros(opts.timeSteps,opts.nShuff);

for t = 1:opts.timeSteps
    % Compute info theoretic quantities

    % Low stimulus info
    tmp_neuSig = squeeze(bNeural.low(:,t))';
    tmpInfo = information(tmp_neuSig, stim, opts, {'I'});
    infovals.MI_lowS(t) = tmpInfo{1};

    % High stimulus info
    tmp_neuSig = squeeze(bNeural.high(:,t))';
    tmpInfo = information(tmp_neuSig, stim, opts, {'I'});
    infovals.MI_highS(t) = tmpInfo{1};

    % Low choice info
    tmp_neuSig = squeeze(bNeural.low(:,t))';
    tmpInfo = information(tmp_neuSig, choice, opts, {'I'});
    infovals.MI_lowC(t) = tmpInfo{1};

    % High choice info
    tmp_neuSig = squeeze(bNeural.high(:,t))';
    tmpInfo = information(tmp_neuSig, choice, opts, {'I'});
    infovals.MI_highC(t) = tmpInfo{1};


    % Compute null hypothesis via permutation
    if opts.doShuff
        for shIdx = 1:opts.nShuff                    
            permIdxs = shIdxs(:,shIdx)';
            % Low stimulus info
            tmp_neuSig = squeeze(bNeural.low(permIdxs,t))';
            tmpInfo = information(tmp_neuSig, stim, opts, {'I'});
            infovals.MIsh_lowS(t,shIdx) = tmpInfo{1};

            % High stimulus info
            tmp_neuSig = squeeze(bNeural.high(permIdxs,t))';
            tmpInfo = information(tmp_neuSig, stim, opts, {'I'});
            infovals.MIsh_highS(t,shIdx) = tmpInfo{1};

            % Low choice info
            tmp_neuSig = squeeze(bNeural.low(permIdxs,t))';
            tmpInfo = information(tmp_neuSig, choice, opts, {'I'});
            infovals.MIsh_lowC(t,shIdx) = tmpInfo{1};

            % High choice info
            tmp_neuSig = squeeze(bNeural.high(permIdxs,t))';
            tmpInfo = information(tmp_neuSig, choice, opts, {'I'});
            infovals.MIsh_highC(t,shIdx) = tmpInfo{1};
        end
    end
end

end