function [ di, diSh ] = DI_infToolBox( X, Y, hY, bias, computeShuffled )

% Computing DI using Magri (2009) infToolBox
% DI(X,Y) = I(hY,X ; Y) - I(hY, Y);

% I(hY,X ; Y)
[R, nt] = buildr(Y, [hY; X]);

diSh = -1;

Opt.nt = nt;
Opt.method = 'dr';
Opt.bias   = bias;
Opt.trperm = 0;

if computeShuffled
    [IhyXY, IhyXYsh] = information(R, Opt, 'I', 'Ish');
    
    % I(hY; Y)
    [R, nt] = buildr(Y, hY);
    Opt.nt = nt;

    [IhyY, IhyYsh] = information(R, Opt, 'I', 'Ish');

    di = IhyXY - IhyY;
    diSh = IhyXYsh - IhyYsh;
else
    IhyXY = information(R, Opt, 'I');

    % I(hY; Y)
    [R, nt] = buildr(Y, hY);
    Opt.nt = nt;

    IhyY = information(R, Opt, 'I');

    di = IhyXY - IhyY;
end
end

