## Installation
1. Install MuJoCo
- Download [MuJoCo key](https://www.roboti.us/license.html) and [MuJoCo 2.1 binaries](https://mujoco.org/download/mujoco210-linux-x86_64.tar.gz)
- Extract the downloaded `mujoco210` and `mjkey.txt` into `~/.mujoco/mujoco210` and `~/.mujoco/mjkey.txt`

2. Add following environment variables into `~/.bashrc`
```
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib/nvidia
```

3. Install and use the included Ananconda environment
```
$ conda create -c nvidia -n Cal-QL python=3.8 cuda-nvcc=11.3
$ conda activate Cal-QL
$ pip install -r requirements.txt
```

4. Set up W&B API keys

This codebase visualizes the logs using [Weights and Biases](https://wandb.ai/site). To enable this, you first need to set up your W&B API key by: 
- Make a file named `wandb_config.py` under `JaxCQL` folder with the following information filled in
```
def get_wandb_config():
    return dict (
        WANDB_API_KEY = 'your api key',
        WANDB_EMAIL = 'your email',
        WANDB_USERNAME = 'user'
    )
```
You can simply copy [JaxCQL/wandb_config_example.py](JaxCQL/wandb_config_example.py), rename it to `wandb_config.py` and fill in the information.

## Run Experiments
### AntMaze
You can run experiments using the following command:
```
$ bash scripts/run_antmaze.sh
```
Please check [scripts/run_antmaze.sh](scripts/run_antmaze.sh) for the details.
All available command options can be seen in conservative\_sac_main.py and conservative_sac.py.

### Adroit Binary
1. Download the offline dataset from [here](https://drive.google.com/file/d/1SsVaQKZnY5UkuR78WrInp9XxTdKHbF0x/view) and unzip the files into `<this repositroy>/demonstrations/offpolicy_hand_data/*.npy` 
2. We should also install `mj_envs` from [this fork](https://github.com/anair13/mj_envs.git) from AWAC's authors.
```
$ git clone --recursive https://github.com/anair13/mj_envs.git
$ git submodule update --remote
$ pip install -e .
```
3. Now you can run experiments using the following command:
 ```
$ bash scripts/run_adroit.sh
```
Please check [scripts/run_adroit.sh](scripts/run_adroit.sh) for the details.
